/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.webactiv.calendar.model.Attendee;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class AttendeeDAO {
    public static final String JOURNALCOLUMNNAMES = "userId, journalId, participationStatus";
    public static final String TODOCOLUMNNAMES = "userId, todoId, participationStatus";
    public static final String JOURNALTABLENAME = "CalendarJournalAttendee";
    public static final String TODOTABLENAME = "CalendarToDoAttendee";
    public static final String JOURNALIDNAME = "journalId";
    public static final String TODOIDNAME = "todoId";

    public static Attendee getAttendeeFromResultSet(ResultSet rs) throws SQLException {
        String userId = rs.getString(1);
        String participation = rs.getString(3);
        Attendee result = new Attendee(userId, participation);
        return result;
    }

    public static Collection getJournalAttendees(Connection con, String journalId) throws SQLException {
        return AttendeeDAO.getAttendees(con, journalId, JOURNALCOLUMNNAMES, JOURNALTABLENAME, JOURNALIDNAME);
    }

    public static Collection getToDoAttendees(Connection con, String todoId) throws SQLException {
        return AttendeeDAO.getAttendees(con, todoId, TODOCOLUMNNAMES, TODOTABLENAME, TODOIDNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAttendees(Connection con, String id, String columns, String table, String idLabel) throws SQLException {
        String selectStatement = "select " + columns + " from " + table + " " + "where " + idLabel + " = " + id;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Attendee> list = new ArrayList<Attendee>();
        try {
            prepStmt = con.prepareStatement(selectStatement);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                Attendee attendee = AttendeeDAO.getAttendeeFromResultSet(rs);
                list.add(attendee);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    public static void addJournalAttendee(Connection con, String journalId, Attendee attendee) throws SQLException {
        AttendeeDAO.addAttendee(con, journalId, attendee, JOURNALCOLUMNNAMES, JOURNALTABLENAME, JOURNALIDNAME);
    }

    public static void addToDoAttendee(Connection con, String todoId, Attendee attendee) throws SQLException {
        AttendeeDAO.addAttendee(con, todoId, attendee, TODOCOLUMNNAMES, TODOTABLENAME, TODOIDNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAttendee(Connection con, String id, Attendee attendee, String columns, String table, String idLabel) throws SQLException {
        String insertStatement = "insert into " + table + " (" + columns + ") " + " values (?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, attendee.getUserId());
            prepStmt.setInt(2, new Integer(id));
            prepStmt.setString(3, attendee.getParticipationStatus().getString());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void removeJournalAttendee(Connection con, String journalId, Attendee attendee) throws SQLException {
        AttendeeDAO.removeAttendee(con, journalId, attendee, JOURNALCOLUMNNAMES, JOURNALTABLENAME, JOURNALIDNAME);
    }

    public static void removeToDoAttendee(Connection con, String todoId, Attendee attendee) throws SQLException {
        AttendeeDAO.removeAttendee(con, todoId, attendee, TODOCOLUMNNAMES, TODOTABLENAME, TODOIDNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAttendee(Connection con, String id, Attendee attendee, String columns, String table, String idLabel) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String statement = "delete from " + table + " " + "where " + idLabel + " = ? and userId = ?";
            prepStmt = con.prepareStatement(statement);
            prepStmt.setInt(1, new Integer(id));
            prepStmt.setString(2, attendee.getUserId());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static void removeJournal(Connection con, String journalId) throws SQLException {
        AttendeeDAO.removeAttendees(con, journalId, JOURNALCOLUMNNAMES, JOURNALTABLENAME, JOURNALIDNAME);
    }

    public static void removeToDo(Connection con, String todoId) throws SQLException {
        AttendeeDAO.removeAttendees(con, todoId, TODOCOLUMNNAMES, TODOTABLENAME, TODOIDNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAttendees(Connection con, String id, String columns, String table, String idLabel) throws SQLException {
        String statement = "delete from " + table + " " + "where " + idLabel + " = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(statement);
            prepStmt.setInt(1, new Integer(id));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }
}

