/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import javax.inject.Inject;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.importexport.control.ImportExport;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.report.ImportReport;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ScheduledImport
implements SchedulerEventListener,
Initialization {
    public static final String IMPORTENGINE_JOB_NAME = "ImportEngineJob";
    private final SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.importExport.settings.importSettings");
    private File dir = null;
    private String postPolicy = null;
    @Inject
    private ImportExport importExport;

    public void init() {
        try {
            String cron = this.resources.getString("cronScheduledImport");
            this.postPolicy = this.resources.getString("postPolicy", "remove");
            String sDir = this.resources.getString("importRepository");
            this.dir = new File(sDir);
            if (!this.dir.exists() && !this.dir.isDirectory()) {
                SilverLogger.getLogger((Object)this).warn("Repository {0} doesn't exist!", new Object[]{sDir});
            } else {
                Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
                scheduler.unscheduleJob(IMPORTENGINE_JOB_NAME);
                JobTrigger trigger = JobTrigger.triggerAt((String)cron);
                scheduler.scheduleJob(IMPORTENGINE_JOB_NAME, trigger, (SchedulerEventListener)this);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void doScheduledImport() {
        String userId = this.resources.getString("userIdAsCreatorId");
        UserDetail user = (UserDetail)OrganizationControllerProvider.getOrganisationController().getUserDetail(userId);
        LocalizationBundle multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.importExportPeas.multilang.importExportPeasBundle");
        MultiSilverpeasBundle resource = new MultiSilverpeasBundle(multilang, "fr");
        File[] files = this.dir.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            String extension;
            if (!file.isFile() || !"xml".equalsIgnoreCase(extension = FileRepositoryManager.getFileExtension((String)file.getName()))) continue;
            try {
                ImportReport importReport = this.importExport.processImport(user, file.getAbsolutePath());
                this.importExport.writeImportToLog(importReport, resource);
                if ("remove".equalsIgnoreCase(this.postPolicy)) {
                    Files.delete(file.toPath());
                    continue;
                }
                if (!"rename".equalsIgnoreCase(this.postPolicy)) continue;
                Files.move(file.toPath(), new File(file.getAbsolutePath() + ".old").toPath(), new CopyOption[0]);
            }
            catch (IOException | ImportExportException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doScheduledImport();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).error("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull", new Object[0]);
    }
}

