/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.ietf.ldap.LDAPAttributeSchema;
import org.ietf.ldap.LDAPDITContentRuleSchema;
import org.ietf.ldap.LDAPDITStructureRuleSchema;
import org.ietf.ldap.LDAPEntry;
import org.ietf.ldap.LDAPMatchingRuleSchema;
import org.ietf.ldap.LDAPMatchingRuleUseSchema;
import org.ietf.ldap.LDAPNameFormSchema;
import org.ietf.ldap.LDAPObjectClassSchema;
import org.ietf.ldap.LDAPSyntaxSchema;

public class LDAPSchema
extends LDAPEntry {
    private com.novell.ldap.LDAPSchema schema;

    LDAPSchema(com.novell.ldap.LDAPSchema novellschema) {
        this.schema = novellschema;
    }

    public LDAPSchema(LDAPEntry entry) {
        this.schema = new com.novell.ldap.LDAPSchema(entry.getWrappedObject());
    }

    public LDAPAttributeSchema getAttributeSchema(String name) {
        com.novell.ldap.LDAPAttributeSchema attr = this.schema.getAttributeSchema(name);
        if (attr == null) {
            return null;
        }
        return new LDAPAttributeSchema(attr);
    }

    public LDAPObjectClassSchema getObjectClassSchema(String name) {
        com.novell.ldap.LDAPObjectClassSchema obj = this.schema.getObjectClassSchema(name);
        if (obj == null) {
            return null;
        }
        return new LDAPObjectClassSchema(obj);
    }

    public LDAPMatchingRuleSchema getMatchingRuleSchema(String name) {
        com.novell.ldap.LDAPMatchingRuleSchema match = this.schema.getMatchingRuleSchema(name);
        if (match == null) {
            return null;
        }
        return new LDAPMatchingRuleSchema(match);
    }

    public LDAPMatchingRuleUseSchema getMatchingRuleUseSchema(String name) {
        com.novell.ldap.LDAPMatchingRuleUseSchema match = this.schema.getMatchingRuleUseSchema(name);
        if (match == null) {
            return null;
        }
        return new LDAPMatchingRuleUseSchema(match);
    }

    public LDAPDITStructureRuleSchema getDITStructureRuleSchema(String name) {
        com.novell.ldap.LDAPDITStructureRuleSchema rule = this.schema.getDITStructureRuleSchema(name);
        if (rule == null) {
            return null;
        }
        return new LDAPDITStructureRuleSchema(rule);
    }

    public LDAPDITStructureRuleSchema getDITStructureRuleSchema(int id) {
        com.novell.ldap.LDAPDITStructureRuleSchema rule = this.schema.getDITStructureRuleSchema(id);
        if (rule == null) {
            return null;
        }
        return new LDAPDITStructureRuleSchema(rule);
    }

    public LDAPDITContentRuleSchema getDITContentRuleSchema(String name) {
        com.novell.ldap.LDAPDITContentRuleSchema rule = this.schema.getDITContentRuleSchema(name);
        if (rule == null) {
            return null;
        }
        return new LDAPDITContentRuleSchema(rule);
    }

    public LDAPNameFormSchema getNameFormSchema(String name) {
        com.novell.ldap.LDAPNameFormSchema form = this.schema.getNameFormSchema(name);
        if (form == null) {
            return null;
        }
        return new LDAPNameFormSchema(form);
    }

    public LDAPSyntaxSchema getSyntaxSchema(String oid) {
        com.novell.ldap.LDAPSyntaxSchema syntax = this.schema.getSyntaxSchema(oid);
        if (syntax == null) {
            return null;
        }
        return new LDAPSyntaxSchema(syntax);
    }

    public Enumeration getAttributeSchemas() {
        class AttrEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            AttrEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPAttributeSchema((com.novell.ldap.LDAPAttributeSchema)this.enumer.nextElement());
            }
        }
        return new AttrEnumWrapper(this.schema.getAttributeSchemas());
    }

    public Enumeration getObjectClassSchemas() {
        class ObjEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            ObjEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPObjectClassSchema((com.novell.ldap.LDAPObjectClassSchema)this.enumer.nextElement());
            }
        }
        return new ObjEnumWrapper(this.schema.getObjectClassSchemas());
    }

    public Enumeration getMatchingRuleSchemas() {
        class MatchEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            MatchEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPMatchingRuleSchema((com.novell.ldap.LDAPMatchingRuleSchema)this.enumer.nextElement());
            }
        }
        return new MatchEnumWrapper(this.schema.getMatchingRuleSchemas());
    }

    public Enumeration getMatchingRuleUseSchemas() {
        class UseEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            UseEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPMatchingRuleUseSchema((com.novell.ldap.LDAPMatchingRuleUseSchema)this.enumer.nextElement());
            }
        }
        return new UseEnumWrapper(this.schema.getMatchingRuleUseSchemas());
    }

    public Enumeration getDITStructureRuleSchemas() {
        class StructEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            StructEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPDITStructureRuleSchema((com.novell.ldap.LDAPDITStructureRuleSchema)this.enumer.nextElement());
            }
        }
        return new StructEnumWrapper(this.schema.getDITStructureRuleSchemas());
    }

    public Enumeration getDITContentRuleSchemas() {
        class ContentEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            ContentEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPDITContentRuleSchema((com.novell.ldap.LDAPDITContentRuleSchema)this.enumer.nextElement());
            }
        }
        return new ContentEnumWrapper(this.schema.getDITContentRuleSchemas());
    }

    public Enumeration getNameFormSchemas() {
        class NameEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            NameEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPNameFormSchema((com.novell.ldap.LDAPNameFormSchema)this.enumer.nextElement());
            }
        }
        return new NameEnumWrapper(this.schema.getNameFormSchemas());
    }

    public Enumeration getSyntaxSchemas() {
        class SyntaxEnumWrapper
        implements Enumeration {
            private Enumeration enumer;

            SyntaxEnumWrapper(Enumeration enumer) {
                this.enumer = enumer;
            }

            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            public Object nextElement() throws NoSuchElementException {
                return new LDAPSyntaxSchema((com.novell.ldap.LDAPSyntaxSchema)this.enumer.nextElement());
            }
        }
        return new SyntaxEnumWrapper(this.schema.getSyntaxSchemas());
    }

    public Enumeration getAttributeNames() {
        return this.schema.getAttributeNames();
    }

    public Enumeration getObjectClassNames() {
        return this.schema.getObjectClassNames();
    }

    public Enumeration getMatchingRuleNames() {
        return this.schema.getMatchingRuleNames();
    }

    public Enumeration getMatchingRuleUseNames() {
        return this.schema.getMatchingRuleUseNames();
    }

    public Enumeration getDITStructureRuleNames() {
        return this.schema.getDITStructureRuleNames();
    }

    public Enumeration getDITContentRuleNames() {
        return this.schema.getDITContentRuleNames();
    }

    public Enumeration getNameFormNames() {
        return this.schema.getNameFormNames();
    }
}

