/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.util.exec.CollectingLogOutputStream;
import org.silverpeas.core.util.exec.ExternalExecutionException;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

public class ExternalExecution {
    protected ExternalExecution() {
    }

    public static List<String> exec(CommandLine commandLine) {
        return ExternalExecution.exec(commandLine, Config.init());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> exec(CommandLine commandLine, Config config) {
        LinkedList<String> result = new LinkedList<String>();
        LinkedList<String> errors = new LinkedList<String>();
        Thread outEater = null;
        try (CollectingLogOutputStream logErrors = new CollectingLogOutputStream(errors);){
            Process process = Runtime.getRuntime().exec(commandLine.toStrings());
            Thread errEater = new Thread(() -> {
                try {
                    errors.addAll(IOUtils.readLines((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset()));
                }
                catch (UncheckedIOException e) {
                    throw new ExternalExecutionException(e);
                }
            });
            errEater.start();
            outEater = new Thread(() -> {
                try {
                    result.addAll(IOUtils.readLines((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()));
                }
                catch (UncheckedIOException e) {
                    throw new ExternalExecutionException(e);
                }
            });
            outEater.start();
            process.waitFor();
            int exitStatus = process.exitValue();
            if (exitStatus != config.getSuccessfulExitStatusValue()) {
                List<String> list = ExternalExecution.stopAll(logErrors, errEater, exitStatus);
                return list;
            }
        }
        catch (IOException | RuntimeException e) {
            ExternalExecution.performExternalExecutionException(config, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ExternalExecution.performExternalExecutionException(config, e);
        }
        try {
            outEater.join();
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private static List<String> stopAll(CollectingLogOutputStream logErrors, Thread errEater, int exitStatus) {
        try {
            errEater.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new SilverpeasRuntimeException("Exit error status : " + exitStatus + " " + logErrors.getMessage());
    }

    private static void performExternalExecutionException(Config config, Exception e) {
        if (config.isDisplayErrorTraceEnabled()) {
            SilverLogger.getLogger(ExternalExecution.class).error("Command execution error: ", (Throwable)e);
        }
        throw new ExternalExecutionException(e);
    }

    public static class Config {
        private int successfulExitStatusValue = 0;
        private boolean displayErrorTrace = true;

        public static Config init() {
            return new Config();
        }

        private Config() {
        }

        public Config successfulExitStatusValueIs(int successfulExitStatusValue) {
            this.successfulExitStatusValue = successfulExitStatusValue;
            return this;
        }

        public int getSuccessfulExitStatusValue() {
            return this.successfulExitStatusValue;
        }

        public Config doNotDisplayErrorTrace() {
            this.displayErrorTrace = false;
            return this;
        }

        public boolean isDisplayErrorTraceEnabled() {
            return this.displayErrorTrace;
        }
    }
}

