/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Objects;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class URLEncoder {
    public static final BitSet GEN_DELIMS = new BitSet(7);
    public static final BitSet SUB_DELIMS = new BitSet(11);
    public static final BitSet RESERVED = new BitSet(2);
    public static final BitSet LOW_ALPHA = new BitSet(26);
    public static final BitSet UP_ALPHA = new BitSet(26);
    public static final BitSet ALPHA = new BitSet(52);
    public static final BitSet DIGIT = new BitSet(10);
    public static final BitSet ALPHANUM = new BitSet(62);
    public static final BitSet UNRESERVED = new BitSet(66);
    public static final BitSet PCHAR = new BitSet(80);
    public static final BitSet PATH_SEGMENT = new BitSet();
    public static final BitSet PATH_PARAM_NAME = new BitSet();
    public static final BitSet PATH_PARAM_VALUE = new BitSet();
    public static final BitSet QUERY = new BitSet();
    public static final BitSet FRAGMENT = new BitSet();

    private URLEncoder() {
    }

    public static String encodePathParamName(String pathParamName) {
        try {
            return URLEncoder.encodePart(pathParamName, Charsets.UTF_8.toString(), PATH_PARAM_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static String encodePathParamValue(String pathParamValue) {
        try {
            return URLEncoder.encodePart(pathParamValue, Charsets.UTF_8.toString(), PATH_PARAM_VALUE);
        }
        catch (UnsupportedEncodingException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static String encodeQueryNameOrValue(String queryNameOrValue) {
        try {
            return URLEncoder.encodePart(queryNameOrValue, Charsets.UTF_8.toString(), QUERY);
        }
        catch (UnsupportedEncodingException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static String encodeQueryNameOrValueNoParen(String queryNameOrValueNoParen) {
        Objects.requireNonNull(queryNameOrValueNoParen);
        try {
            String query = URLEncoder.encodePart(queryNameOrValueNoParen, Charsets.UTF_8.toString(), QUERY);
            query = query.replace("(", "");
            return query.replace(")", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static String encodePathSegment(String pathSegment) {
        try {
            return URLEncoder.encodePart(pathSegment, Charsets.UTF_8.toString(), PATH_SEGMENT);
        }
        catch (UnsupportedEncodingException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static String encodePart(String part, String charset, BitSet allowed) throws UnsupportedEncodingException {
        char[] toEncode;
        if (part == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder(part.length() * 3);
        for (char c : toEncode = part.toCharArray()) {
            byte[] bytes;
            if (allowed.get(c)) {
                encoded.append(c);
                continue;
            }
            for (byte b : bytes = String.valueOf(c).getBytes(charset)) {
                int u8 = b & 0xFF;
                encoded.append(String.format("%%%1$02X", u8));
            }
        }
        return encoded.toString();
    }

    static {
        GEN_DELIMS.set(58);
        GEN_DELIMS.set(47);
        GEN_DELIMS.set(63);
        GEN_DELIMS.set(35);
        GEN_DELIMS.set(91);
        GEN_DELIMS.set(93);
        GEN_DELIMS.set(64);
        SUB_DELIMS.set(33);
        SUB_DELIMS.set(36);
        SUB_DELIMS.set(38);
        SUB_DELIMS.set(39);
        SUB_DELIMS.set(40);
        SUB_DELIMS.set(41);
        SUB_DELIMS.set(42);
        SUB_DELIMS.set(43);
        SUB_DELIMS.set(44);
        SUB_DELIMS.set(59);
        SUB_DELIMS.set(61);
        RESERVED.or(GEN_DELIMS);
        RESERVED.or(SUB_DELIMS);
        LOW_ALPHA.set(97);
        LOW_ALPHA.set(98);
        LOW_ALPHA.set(99);
        LOW_ALPHA.set(100);
        LOW_ALPHA.set(101);
        LOW_ALPHA.set(102);
        LOW_ALPHA.set(103);
        LOW_ALPHA.set(104);
        LOW_ALPHA.set(105);
        LOW_ALPHA.set(106);
        LOW_ALPHA.set(107);
        LOW_ALPHA.set(108);
        LOW_ALPHA.set(109);
        LOW_ALPHA.set(110);
        LOW_ALPHA.set(111);
        LOW_ALPHA.set(112);
        LOW_ALPHA.set(113);
        LOW_ALPHA.set(114);
        LOW_ALPHA.set(115);
        LOW_ALPHA.set(116);
        LOW_ALPHA.set(117);
        LOW_ALPHA.set(118);
        LOW_ALPHA.set(119);
        LOW_ALPHA.set(120);
        LOW_ALPHA.set(121);
        LOW_ALPHA.set(122);
        UP_ALPHA.set(65);
        UP_ALPHA.set(66);
        UP_ALPHA.set(67);
        UP_ALPHA.set(68);
        UP_ALPHA.set(69);
        UP_ALPHA.set(70);
        UP_ALPHA.set(71);
        UP_ALPHA.set(72);
        UP_ALPHA.set(73);
        UP_ALPHA.set(74);
        UP_ALPHA.set(75);
        UP_ALPHA.set(76);
        UP_ALPHA.set(77);
        UP_ALPHA.set(78);
        UP_ALPHA.set(79);
        UP_ALPHA.set(80);
        UP_ALPHA.set(81);
        UP_ALPHA.set(82);
        UP_ALPHA.set(83);
        UP_ALPHA.set(84);
        UP_ALPHA.set(85);
        UP_ALPHA.set(86);
        UP_ALPHA.set(87);
        UP_ALPHA.set(88);
        UP_ALPHA.set(89);
        UP_ALPHA.set(90);
        ALPHA.or(LOW_ALPHA);
        ALPHA.or(UP_ALPHA);
        DIGIT.set(48);
        DIGIT.set(49);
        DIGIT.set(50);
        DIGIT.set(51);
        DIGIT.set(52);
        DIGIT.set(53);
        DIGIT.set(54);
        DIGIT.set(55);
        DIGIT.set(56);
        DIGIT.set(57);
        ALPHANUM.or(ALPHA);
        ALPHANUM.or(DIGIT);
        UNRESERVED.or(ALPHA);
        UNRESERVED.or(DIGIT);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        PCHAR.or(UNRESERVED);
        PCHAR.or(SUB_DELIMS);
        PCHAR.set(58);
        PCHAR.set(64);
        PATH_SEGMENT.or(PCHAR);
        PATH_SEGMENT.clear(59);
        PATH_PARAM_NAME.or(PCHAR);
        PATH_PARAM_NAME.clear(59);
        PATH_PARAM_NAME.clear(61);
        PATH_PARAM_VALUE.or(PCHAR);
        PATH_PARAM_VALUE.clear(59);
        QUERY.or(PCHAR);
        QUERY.set(47);
        QUERY.set(63);
        QUERY.clear(61);
        QUERY.clear(38);
        QUERY.clear(43);
        FRAGMENT.or(PCHAR);
        FRAGMENT.set(47);
        FRAGMENT.set(63);
    }
}

