/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.util.CollectionUtil;

public class SubscriptionSubscriberMapBySubscriberType
extends HashMap<SubscriberType, SubscriptionSubscriberList> {
    private static final long serialVersionUID = 450436743664606932L;

    public SubscriptionSubscriberMapBySubscriberType(SubscriptionSubscriber ... subscribers) {
        this.initialize().addAll(Arrays.asList(subscribers));
    }

    public SubscriptionSubscriberMapBySubscriberType(Collection<SubscriptionSubscriber> subscribers) {
        this.initialize().addAll(subscribers);
    }

    private SubscriptionSubscriberMapBySubscriberType initialize() {
        for (SubscriberType subscriberType : SubscriberType.getValidValues()) {
            this.put(subscriberType, new SubscriptionSubscriberList());
        }
        return this;
    }

    public void addAll(Collection<SubscriptionSubscriber> subscribers) {
        if (CollectionUtil.isNotEmpty(subscribers)) {
            for (SubscriptionSubscriber subscriber : subscribers) {
                this.add(subscriber);
            }
        }
    }

    public void addAll(SubscriptionSubscriberMapBySubscriberType subscribers) {
        if (subscribers != null) {
            for (Collection subscriptionSubscribers : subscribers.values()) {
                this.addAll(subscriptionSubscribers);
            }
        }
    }

    public void add(SubscriptionSubscriber subscriber) {
        SubscriptionSubscriberList current;
        if (subscriber != null && !(current = (SubscriptionSubscriberList)this.get((Object)subscriber.getType())).contains(subscriber)) {
            current.add(subscriber);
        }
    }

    public List<String> getAllUserIds() {
        HashSet<String> userIds = new HashSet<String>();
        for (SubscriptionSubscriberList subscriptionSubscribers : this.values()) {
            userIds.addAll(subscriptionSubscribers.getAllUserIds());
        }
        return new ArrayList<String>(userIds);
    }

    public SubscriptionSubscriberMapBySubscriberType filterOnDomainVisibilityFrom(UserDetail user) {
        for (Map.Entry entry : this.entrySet()) {
            ((SubscriptionSubscriberList)entry.getValue()).filterOnDomainVisibilityFrom(user);
        }
        return this;
    }
}

