/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.rule;

import java.util.regex.Pattern;
import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.AbstractPasswordRule;
import org.silverpeas.kernel.util.StringUtil;

public class BlankForbiddenPasswordRule
extends AbstractPasswordRule {
    private static final String TRUE = String.valueOf(Boolean.TRUE);
    private static final String FALSE = String.valueOf(Boolean.FALSE);
    private boolean value;

    public BlankForbiddenPasswordRule() {
        super(PasswordRuleType.BLANK_FORBIDDEN);
        String stringValue = settings.getString(this.getType().getSettingKey(), TRUE);
        if (!stringValue.equals(TRUE) && !stringValue.equals(FALSE)) {
            stringValue = TRUE;
        }
        this.value = Boolean.valueOf(stringValue);
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined((String)password) && !Pattern.compile("[ ]+").matcher(password).find();
    }

    @Override
    public String random() {
        return this.isRequired() ? "" : " ";
    }
}

