/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.silverpeas.core.security.authentication.AuthenticationConnection;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationSQL;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationHostException;
import org.silverpeas.kernel.bundle.SettingBundle;

public class AuthenticationCAS
extends AuthenticationSQL {
    private String query;
    private String lowerCaseQuery;

    @Override
    public void loadProperties(SettingBundle settings) {
        String serverName = this.getServerName();
        this.dataSourceJndiName = settings.getString(serverName + ".SQLDataSourceJNDIName");
        this.userTableName = settings.getString(serverName + ".SQLUserTableName");
        this.loginColumnName = settings.getString(serverName + ".SQLUserLoginColumnName");
        String queryBase = "select " + this.loginColumnName + " from " + this.userTableName + " where ";
        this.query = queryBase + this.loginColumnName + " = ?";
        this.lowerCaseQuery = queryBase + "lower(" + this.loginColumnName + ") = lower(?)";
    }

    @Override
    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        try (PreparedStatement stmt = AuthenticationCAS.getSQLConnection(connection).prepareStatement(credential.loginIgnoreCase() ? this.lowerCaseQuery : this.query);){
            stmt.setString(1, credential.getLogin());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    throw new AuthenticationBadCredentialException("User not found with login: " + credential.getLogin(), new String[0]);
                }
            }
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException((Throwable)ex);
        }
    }
}

