/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.persistence.jcr.JcrDataConverter;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractJcrConverter {
    protected String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return null;
    }

    protected String getComponentId(Node node) throws RepositoryException {
        return JcrDataConverter.convertFromJcrPath(node.getAncestor(1).getName());
    }

    public void addStringProperty(Node node, String propertyName, String value) throws RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
        } else {
            node.setProperty(propertyName, value);
        }
    }

    public void addDateProperty(Node node, String propertyName, Date value) throws RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            Value propertyValue = node.getSession().getValueFactory().createValue(calendar);
            node.setProperty(propertyName, propertyValue);
        }
    }

    protected Date getDateProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    protected int getIntProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return Long.valueOf(node.getProperty(propertyName).getLong()).intValue();
        }
        return 0;
    }

    protected Boolean getBooleanProperty(Node node, String propertyName, Boolean defaultValueIfNull) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getBoolean();
        }
        return defaultValueIfNull;
    }

    protected long getLongProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getLong();
        }
        return 0L;
    }

    public void setContent(Node fileNode, InputStream content, String mimeType) throws RepositoryException {
        Node contentNode = fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") ? fileNode.getNode("{http://www.jcp.org/jcr/1.0}content") : fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "nt:resource");
        Binary binaryContent = fileNode.getSession().getValueFactory().createBinary(content);
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binaryContent);
        binaryContent.dispose();
        String fileMimeType = mimeType;
        if (fileMimeType == null) {
            fileMimeType = FileUtil.getMimeType(fileNode.getProperty("slv:name").getString());
        }
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}encoding", Charsets.UTF_8.name());
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", fileMimeType);
        Calendar lastModified = Calendar.getInstance();
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", lastModified);
    }

    public void setContent(Node fileNode, File file, String mimeType) throws RepositoryException {
        try (FileInputStream in = new FileInputStream(file);){
            this.setContent(fileNode, in, mimeType);
        }
        catch (IOException ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void setContent(Node fileNode, byte[] content, String mimeType) throws RepositoryException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);){
            this.setContent(fileNode, in, mimeType);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] getContent(Node fileNode) throws RepositoryException {
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            try (InputStream in = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getStream();){
                byte[] byArray;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            catch (IOException ex) {
                throw new RepositoryException((Throwable)ex);
            }
        }
        return ArrayUtil.emptyByteArray();
    }

    public Binary getBinaryContent(Node fileNode) throws RepositoryException {
        Node contentNode;
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") && (contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content")).hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
            return contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContent(Node fileNode, OutputStream out) throws RepositoryException, IOException {
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            Binary content = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
            try (InputStream in = content.getStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                content.dispose();
            }
        }
    }

    public Node getFolder(Node parent, String name) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}folder");
    }

    public static boolean isMixinApplied(Node node, String mixin) throws RepositoryException {
        return Arrays.stream(node.getMixinNodeTypes()).anyMatch(m -> m.isNodeType(mixin));
    }
}

