/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.coordinates.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.coordinates.model.CoordinatePK;
import org.silverpeas.core.node.coordinates.model.CoordinatePoint;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class CoordinatesDAO {
    public static final String COORDINATESCOLUMNNAMES = "coordinatesId, nodeId, coordinatesLeaf,coordinatesDisplayOrder,instanceId";
    private static final String SELECT_BY_NODEID = "SELECT DISTINCT(coordinatesId) AS id FROM sb_coordinates_coordinates WHERE nodeid = ? AND instanceid = ? ";
    private static final String SELECT_BY_COMPONENT = "SELECT DISTINCT(coordinatesid) FROM sb_coordinates_coordinates WHERE instanceid = ?";
    private static final String SELECT_BY_PK = "SELECT coordinatesid, nodeid, coordinatesleaf, coordinatesdisplayorder,instanceid FROM sb_coordinates_coordinates WHERE coordinatesid = ? AND coordinatesleaf = ? AND instanceid = ? ORDER BY coordinatesdisplayorder ";
    private static final String SELECT_MAX_ORDER = "SELECT MAX(coordinatesdisplayorder) FROM sb_coordinates_coordinates WHERE instanceId= ?";
    private static final String SELECT_MAX_ID = "SELECT MAX(coordinatesid) FROM sb_coordinates_coordinates WHERE instanceid = ?";
    private static final String INSERT_COORDINATE = "INSERT INTO sb_coordinates_coordinates (coordinatesid, nodeid, coordinatesleaf, coordinatesdisplayorder, instanceid) VALUES ( ? , ? , ? , ? , ?)";
    private static final String DELETE_COORDINATES_BY_INSTANCEID = "DELETE FROM sb_coordinates_coordinates where instanceId = ?";
    private static final String NODE_ID_EQUALS_TO = " nodeId = ";

    private static CoordinatePoint getCoordinatePointFromResultSet(ResultSet rs) throws SQLException {
        int coordinateId = rs.getInt("coordinatesId");
        int nodeId = rs.getInt("nodeid");
        boolean leaf = "1".equals(rs.getString("coordinatesleaf"));
        return new CoordinatePoint(coordinateId, nodeId, leaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CoordinatePoint> selectCoordinatePointsByNodeIds(Connection con, List<Integer> fatherIds, CoordinatePK pk) throws SQLException {
        ArrayList<CoordinatePoint> list = new ArrayList<CoordinatePoint>();
        StringBuilder whereClause = new StringBuilder(20 * fatherIds.size() + 200);
        Iterator<Integer> it = fatherIds.iterator();
        whereClause.append("(");
        while (it.hasNext()) {
            whereClause.append(NODE_ID_EQUALS_TO).append(it.next());
            if (it.hasNext()) {
                whereClause.append(" OR ");
                continue;
            }
            whereClause.append(" ) ");
        }
        String selectQuery = "SELECT coordinatesId, nodeId, coordinatesLeaf, coordinatesDisplayOrder, instanceId FROM sb_coordinates_coordinates WHERE " + whereClause + " AND instanceId = '" + pk.getComponentName() + "'  ORDER BY coordinatesId, nodeId ASC";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectQuery);
            while (rs.next()) {
                CoordinatePoint coordinatePoint = CoordinatesDAO.getCoordinatePointFromResultSet(rs);
                list.add(coordinatePoint);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return list;
    }

    private static int getNbMatchingCoordinates(int currentCoordinateId, List<Integer> fatherIds, List<CoordinatePoint> toCheck, int begin) {
        int i = begin;
        int f = 1;
        boolean coordinateMatch = true;
        int nbMatchingCoordinates = 0;
        while (i < toCheck.size() && coordinateMatch) {
            CoordinatePoint coordinatePoint = toCheck.get(i);
            int currentRId = coordinatePoint.getCoordinateId();
            int currentNId = coordinatePoint.getNodeId();
            if (currentRId == currentCoordinateId && currentNId == fatherIds.get(f)) {
                ++nbMatchingCoordinates;
                ++f;
                ++i;
                continue;
            }
            coordinateMatch = false;
        }
        return nbMatchingCoordinates;
    }

    public static Collection<String> selectByFatherIds(Connection con, List<Integer> fatherIds, CoordinatePK pk) throws SQLException {
        List<CoordinatePoint> points = CoordinatesDAO.selectCoordinatePointsByNodeIds(con, fatherIds, pk);
        ArrayList<CoordinatePoint> toCheck = new ArrayList<CoordinatePoint>(points);
        ArrayList<String> coordinatePKs = new ArrayList<String>();
        int nbAxis = fatherIds.size();
        int nbMatchingPoints = 0;
        for (int i = 0; i < points.size(); ++i) {
            CoordinatePoint point = points.get(i);
            int currentCoordinateId = point.getCoordinateId();
            if (point.getNodeId() != fatherIds.get(0).intValue() || (nbMatchingPoints = CoordinatesDAO.getNbMatchingCoordinates(currentCoordinateId, fatherIds, toCheck, i + 1)) != nbAxis - 1) continue;
            coordinatePKs.add(String.valueOf(currentCoordinateId));
            i += nbMatchingPoints;
        }
        return coordinatePKs;
    }

    public static Collection<String> selectByFatherPaths(Connection con, List<String> fatherPaths, CoordinatePK pk) throws SQLException {
        return CoordinatesDAO.selectCoordinateIdsByNodeIds(con, fatherPaths, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> selectCoordinateIdsByNodeIds(Connection con, List<String> fatherPaths, CoordinatePK pk) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet rs = null;
        String fatherPath = "";
        StringBuilder whereClause = new StringBuilder();
        String fatherId = "";
        String rootFatherId = "";
        int axisToMatch = fatherPaths.size();
        Iterator<String> it = fatherPaths.iterator();
        while (it.hasNext()) {
            fatherPath = it.next();
            fatherPath = fatherPath.substring(1);
            fatherPath = fatherPath.substring(fatherPath.indexOf(47) + 1, fatherPath.length());
            fatherId = fatherPath.substring(fatherPath.lastIndexOf(47) + 1, fatherPath.length());
            rootFatherId = fatherPath.substring(0, fatherPath.indexOf(47));
            whereClause.append(NODE_ID_EQUALS_TO).append(fatherId);
            whereClause.append(" or (nodeId = ").append(rootFatherId).append(" and coordinatesLeaf = '1') ");
            if (!it.hasNext()) continue;
            whereClause.append(" Or ");
        }
        String selectStatement = "select coordinatesId, count(*) from " + pk.getTableName() + " ";
        if (!fatherPaths.isEmpty()) {
            selectStatement = selectStatement + "where " + whereClause.toString();
        }
        selectStatement = selectStatement + " And instanceId = '" + pk.getComponentName() + "' ";
        selectStatement = selectStatement + " GROUP BY coordinatesId";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            rs = prepStmt.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            int coordinateId = 0;
            int nbMatches = 0;
            while (rs.next()) {
                coordinateId = rs.getInt(1);
                nbMatches = rs.getInt(2);
                if (nbMatches != axisToMatch) continue;
                list.add(Integer.toString(coordinateId));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCoordinatePoint(Connection con, CoordinatePK pk, CoordinatePoint point, int coordinateId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(INSERT_COORDINATE);
            prepStmt.setInt(1, coordinateId);
            prepStmt.setInt(2, point.getNodeId());
            if (point.isLeaf()) {
                prepStmt.setString(3, "1");
            } else {
                prepStmt.setString(3, "0");
            }
            prepStmt.setInt(4, point.getOrder());
            prepStmt.setString(5, pk.getComponentName());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static int addCoordinate(Connection con, CoordinatePK pk, List<CoordinatePoint> coordinatePoints) throws SQLException {
        int coordinateId = CoordinatesDAO.getMaxCoordinateId(con, pk) + 1;
        for (CoordinatePoint point : coordinatePoints) {
            CoordinatesDAO.addCoordinatePoint(con, pk, point, coordinateId);
        }
        return coordinateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCoordinates(Connection con, CoordinatePK pk, List<String> coordinateIds) throws SQLException {
        StringBuilder deleteQuery = new StringBuilder("DELETE FROM sb_coordinates_coordinates WHERE ");
        if (coordinateIds != null) {
            Iterator<String> it = coordinateIds.iterator();
            deleteQuery.append("(");
            while (it.hasNext()) {
                String coordinateId = it.next();
                deleteQuery.append(" coordinatesId = ").append(coordinateId);
                if (!it.hasNext()) continue;
                deleteQuery.append(" OR ");
            }
            deleteQuery.append(" ) ");
        }
        deleteQuery.append(" AND instanceId = '").append(pk.getComponentName()).append("'");
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(deleteQuery.toString());
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCoordinatesByPoints(Connection con, CoordinatePK pk, List<String> coordinatePoints) throws SQLException {
        StringBuilder deleteQuery = new StringBuilder("DELETE FROM sb_coordinates_coordinates WHERE ");
        if (coordinatePoints != null) {
            Iterator<String> it = coordinatePoints.iterator();
            deleteQuery.append("(");
            while (it.hasNext()) {
                String pointId = it.next();
                deleteQuery.append(NODE_ID_EQUALS_TO).append(pointId);
                if (!it.hasNext()) continue;
                deleteQuery.append(" or ");
            }
            deleteQuery.append(" ) ");
        }
        deleteQuery.append(" AND instanceId ='").append(pk.getComponentName()).append("'");
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(deleteQuery.toString());
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public static void removeCoordinatesByInstanceId(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement deletion = con.prepareStatement(DELETE_COORDINATES_BY_INSTANCEID);){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaxCoordinateId(Connection con, CoordinatePK pk) throws SQLException {
        int maxFromTable = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(SELECT_MAX_ID);
            pstmt.setString(1, pk.getComponentName());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxFromTable = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return Integer.parseInt("2") + maxFromTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaxDisplayOrder(Connection con, CoordinatePK pk) throws SQLException {
        int maxFromTable = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(SELECT_MAX_ORDER);
            pstmt.setString(1, pk.getComponentName());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxFromTable = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return maxFromTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Coordinate selectCoordinateByCoordinatePK(Connection con, CoordinatePK pk) throws SQLException {
        ArrayList<CoordinatePoint> list = new ArrayList<CoordinatePoint>();
        int id = Integer.parseInt(pk.getId());
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(SELECT_BY_PK);
            prepStmt.setInt(1, id);
            prepStmt.setString(2, "1");
            prepStmt.setString(3, pk.getComponentName());
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                list.add(CoordinatesDAO.getCoordinatePointFromResultSet(rs));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return new Coordinate(id, list);
    }

    public static List<Coordinate> selectCoordinatesByCoordinateIds(Connection con, List<String> coordinateIds, CoordinatePK pk) throws SQLException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (String coordinateId : coordinateIds) {
            coordinates.add(CoordinatesDAO.selectCoordinateByCoordinatePK(con, new CoordinatePK(coordinateId, pk)));
        }
        return coordinates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<String> getCoordinateIds(Connection con, CoordinatePK pk) throws SQLException {
        ArrayList<String> coordinateIds = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(SELECT_BY_COMPONENT);
            pstmt.setString(1, pk.getComponentName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                coordinateIds.add(rs.getString("coordinatesid"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)pstmt);
        return coordinateIds;
    }

    public static void addPointToAllCoordinates(Connection con, CoordinatePK pk, CoordinatePoint point) throws SQLException {
        int maxDisplayOrder = CoordinatesDAO.getMaxDisplayOrder(con, pk);
        point.setOrder(maxDisplayOrder + 1);
        Collection<String> coordinateIds = CoordinatesDAO.getCoordinateIds(con, pk);
        for (String id : coordinateIds) {
            int coordinateId = Integer.parseInt(id);
            CoordinatesDAO.addCoordinatePoint(con, pk, point, coordinateId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getCoordinateIdsByNodeId(Connection con, CoordinatePK pk, String nodeId) throws SQLException {
        ArrayList<String> coordinateIds = new ArrayList<String>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(SELECT_BY_NODEID);
            prepStmt.setInt(1, Integer.parseInt(nodeId));
            prepStmt.setString(2, pk.getComponentName());
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                coordinateIds.add(rs.getString("id"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return coordinateIds;
    }

    private CoordinatesDAO() {
    }
}

