/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.mail.Message;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.util.CollectionUtil;

public class ReceiverMailAddressSet
extends LinkedHashSet<MailAddress> {
    private static final long serialVersionUID = 6660986678159523787L;
    private static final int DEFAULT_BATCH_SIZE = 0;
    private MailRecipientType recipientType = MailRecipientType.TO;
    private int receiversBatchSizeForOneSend = 0;

    public static ReceiverMailAddressSet with(MailAddress ... mailAddresses) {
        return ReceiverMailAddressSet.with(CollectionUtil.asList((Object[])mailAddresses));
    }

    public static ReceiverMailAddressSet with(Collection<MailAddress> mailAddresses) {
        ReceiverMailAddressSet list = new ReceiverMailAddressSet();
        if (mailAddresses != null) {
            list.addAll(mailAddresses);
        }
        return list;
    }

    public static ReceiverMailAddressSet ofRecipientType(MailRecipientType mailRecipientType) {
        return new ReceiverMailAddressSet().withRecipientType(mailRecipientType);
    }

    private ReceiverMailAddressSet() {
    }

    public MailRecipientType getRecipientType() {
        return this.recipientType;
    }

    public ReceiverMailAddressSet withRecipientType(MailRecipientType recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    int getReceiversBatchSizeForOneSend() {
        return this.receiversBatchSizeForOneSend;
    }

    public ReceiverMailAddressSet withReceiversBatchSizeOf(int receiversBatchSizeForOneSend) {
        this.receiversBatchSizeForOneSend = receiversBatchSizeForOneSend >= 0 ? receiversBatchSizeForOneSend : 0;
        return this;
    }

    public List<ReceiverMailAddressSet> getBatchedReceiversList() {
        if (this.size() <= this.getReceiversBatchSizeForOneSend() || this.getReceiversBatchSizeForOneSend() == 0) {
            return Collections.singletonList(this);
        }
        ArrayList<ReceiverMailAddressSet> batchedReceiverList = new ArrayList<ReceiverMailAddressSet>(this.size() / this.getReceiversBatchSizeForOneSend() + 1);
        HashSet current = null;
        for (MailAddress mailAddress : this) {
            if (current == null || current.size() == this.getReceiversBatchSizeForOneSend()) {
                current = new ReceiverMailAddressSet().withRecipientType(this.getRecipientType()).withReceiversBatchSizeOf(this.getReceiversBatchSizeForOneSend());
                batchedReceiverList.add((ReceiverMailAddressSet)current);
            }
            current.add(mailAddress);
        }
        return batchedReceiverList;
    }

    public String getEmailsSeparatedByComma() {
        String comma = ",";
        StringBuilder sb = new StringBuilder(30 * this.size());
        for (MailAddress mailAddress : this) {
            if (sb.length() > 0) {
                sb.append(comma);
            }
            sb.append(mailAddress.getEmail());
        }
        return sb.toString();
    }

    public static enum MailRecipientType {
        TO(Message.RecipientType.TO),
        CC(Message.RecipientType.CC),
        BCC(Message.RecipientType.BCC);

        private final Message.RecipientType type;

        private MailRecipientType(Message.RecipientType type) {
            this.type = type;
        }

        public Message.RecipientType getTechnicalType() {
            return this.type;
        }
    }
}

