/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.thumbnail.control;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.ActionType;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailDummyHandledFile;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailSimulationElement;
import org.silverpeas.core.process.annotation.AbstractDummyHandledFileConverter;
import org.silverpeas.core.process.io.file.DummyHandledFile;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ThumbnailDummyHandledFileConverter
extends AbstractDummyHandledFileConverter<ThumbnailSimulationElement> {
    @Override
    public List<DummyHandledFile> convert(List<ThumbnailSimulationElement> elements, ResourceReference target, ActionType actionType) {
        LinkedList<DummyHandledFile> dummyHandledFiles = new LinkedList<DummyHandledFile>();
        if (actionType.isCreate() || actionType.isUpdate() || actionType.isCopy() || actionType.isMove()) {
            for (ThumbnailSimulationElement thumbnail : elements) {
                String thumbnailRootPath = ThumbnailController.getImageDirectory(((Thumbnail)thumbnail.getElement()).getReference().getComponentInstanceId());
                for (String thumbnailName : new String[]{((Thumbnail)thumbnail.getElement()).getCropFileName(), ((Thumbnail)thumbnail.getElement()).getOriginalFileName()}) {
                    if (StringUtil.isNotDefined((String)thumbnailName)) continue;
                    File thumbnailFile = FileUtils.getFile((String[])new String[]{thumbnailRootPath, thumbnailName});
                    this.performTask(target, actionType, dummyHandledFiles, thumbnail, thumbnailFile);
                }
            }
        }
        return dummyHandledFiles;
    }

    private void performTask(ResourceReference target, ActionType actionType, List<DummyHandledFile> dummyHandledFiles, ThumbnailSimulationElement thumbnail, File thumbnailFile) {
        if (thumbnailFile.exists() && thumbnailFile.isFile()) {
            if (actionType.isUpdate() && thumbnail.isOld() || actionType.isMove() && !thumbnail.isOld()) {
                dummyHandledFiles.add(new ThumbnailDummyHandledFile((Thumbnail)thumbnail.getElement(), thumbnailFile, true));
            }
            if (!thumbnail.isOld()) {
                dummyHandledFiles.add(new ThumbnailDummyHandledFile((Thumbnail)thumbnail.getElement(), thumbnailFile, target));
            }
        }
    }
}

