/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.thumbnail.control;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.transaction.Transactional;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileDescriptor;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.option.CropOption;
import org.silverpeas.core.io.media.image.option.DimensionOption;
import org.silverpeas.core.io.media.image.option.OrientationOption;
import org.silverpeas.core.io.media.image.thumbnail.ThumbnailException;
import org.silverpeas.core.io.media.image.thumbnail.ThumbnailRuntimeException;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.io.media.image.thumbnail.service.ThumbnailService;
import org.silverpeas.core.io.media.image.thumbnail.service.ThumbnailServiceProvider;
import org.silverpeas.core.util.ImageUtil;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ThumbnailController
implements ComponentInstanceDeletion {
    private static final SettingBundle publicationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.publication.publicationSettings");

    private static ThumbnailService getThumbnailService() {
        return ThumbnailServiceProvider.getThumbnailService();
    }

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try {
            ThumbnailController.getThumbnailService().deleteAllThumbnail(componentInstanceId);
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
        try {
            FileFolderManager.deleteFolder(ThumbnailController.getImageDirectory(componentInstanceId));
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    public static boolean processThumbnail(ResourceReference pk, List<FileItem> parameters) throws IOException {
        boolean thumbnailChanged;
        String nameImageFromGallery;
        String logicalName;
        ThumbnailDetail detail = new ThumbnailDetail(pk.getInstanceId(), Integer.parseInt(pk.getId()), 1);
        String mimeType = null;
        Object physicalName = null;
        FileItem uploadedFile = FileUploadUtil.getFile(parameters, "WAIMGVAR0");
        if (uploadedFile != null && StringUtil.isDefined((String)(logicalName = uploadedFile.getName().replace('\\', '/')))) {
            logicalName = FilenameUtils.getName((String)logicalName);
            mimeType = FileUtil.getMimeType(logicalName);
            String type = FileRepositoryManager.getFileExtension(logicalName);
            if (FileUtil.isImage(logicalName)) {
                physicalName = String.valueOf(System.currentTimeMillis()) + "." + type;
                SilverpeasFileDescriptor descriptor = new SilverpeasFileDescriptor(detail.getInstanceId()).mimeType(mimeType).parentDirectory(publicationSettings.getString("imagesSubDirectory")).fileName((String)physicalName);
                SilverpeasFile target = SilverpeasFileProvider.newFile(descriptor);
                target.writeFrom(uploadedFile.getInputStream());
            } else {
                throw new ThumbnailRuntimeException("Not an image");
            }
        }
        if (physicalName == null && StringUtil.isDefined((String)(nameImageFromGallery = FileUploadUtil.getParameter(parameters, "valueImageGallery")))) {
            physicalName = nameImageFromGallery;
            mimeType = "image/jpeg";
        }
        if (StringUtil.isDefined(physicalName)) {
            detail.setOriginalFileName((String)physicalName);
            detail.setMimeType(mimeType);
            thumbnailChanged = ThumbnailController.changeThumbnail(detail);
        } else if (StringUtil.getBooleanValue((String)FileUploadUtil.getParameter(parameters, "ThumbnailDeletion"))) {
            ThumbnailController.deleteThumbnail(detail);
            thumbnailChanged = true;
        } else {
            thumbnailChanged = false;
        }
        Integer xStart = ThumbnailController.getParameterAsInteger(parameters, "XStart");
        if (xStart != null) {
            detail.setXStart(xStart);
            detail.setYStart(ThumbnailController.getParameterAsInteger(parameters, "YStart"));
            detail.setXLength(ThumbnailController.getParameterAsInteger(parameters, "XLength"));
            detail.setYLength(ThumbnailController.getParameterAsInteger(parameters, "YLength"));
            ThumbnailController.cropThumbnail(detail, ThumbnailController.getParameterAsInteger(parameters, "ThumbnailWidth"), ThumbnailController.getParameterAsInteger(parameters, "ThumbnailHeight"));
        }
        return thumbnailChanged;
    }

    private static Integer getParameterAsInteger(List<FileItem> parameters, String parameterName) {
        return Optional.ofNullable(FileUploadUtil.getParameter(parameters, parameterName)).map(Integer::parseInt).orElse(null);
    }

    private static boolean changeThumbnail(ThumbnailDetail detail) {
        try {
            ThumbnailController.updateThumbnail(detail);
            return true;
        }
        catch (ThumbnailRuntimeException e) {
            SilverLogger.getLogger(ThumbnailController.class).error((Throwable)((Object)e));
            try {
                ThumbnailController.deleteThumbnail(detail);
            }
            catch (Exception exp) {
                SilverLogger.getLogger(ThumbnailController.class).silent((Throwable)((Object)e));
            }
            return false;
        }
    }

    public static void updateThumbnail(ThumbnailDetail toUpdate) {
        try {
            ThumbnailController.deleteThumbnail(toUpdate);
            toUpdate.setCropFileName(null);
            toUpdate.setXLength(-1);
            toUpdate.setXStart(-1);
            toUpdate.setYLength(-1);
            toUpdate.setYStart(-1);
            ThumbnailController.getThumbnailService().createThumbnail(toUpdate);
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    public static void deleteThumbnail(ThumbnailDetail toDelete) {
        try {
            ThumbnailDetail current = ThumbnailController.getThumbnailService().getCompleteThumbnail(toDelete);
            if (current != null) {
                if (current.getOriginalFileName() != null) {
                    ThumbnailController.deleteThumbnailFileOnServer(current.getInstanceId(), current.getOriginalFileName());
                }
                if (current.getCropFileName() != null) {
                    ThumbnailController.deleteThumbnailFileOnServer(current.getInstanceId(), current.getCropFileName());
                }
                ThumbnailController.getThumbnailService().deleteThumbnail(toDelete);
            }
        }
        catch (Exception fe) {
            throw new ThumbnailRuntimeException(fe);
        }
    }

    public static ThumbnailDetail createThumbnail(ThumbnailDetail thumbDetail, int thumbnailWidth, int thumbnailHeight) {
        try {
            ThumbnailDetail thumdAdded = ThumbnailController.getThumbnailService().createThumbnail(thumbDetail);
            if (thumdAdded.getCropFileName() == null && thumdAdded.canBeCropped()) {
                ThumbnailController.createCropFile(thumbnailWidth, thumbnailHeight, thumdAdded);
            }
            return thumdAdded;
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    public static ThumbnailDetail getCompleteThumbnail(ThumbnailDetail thumbDetail) {
        try {
            return ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbDetail);
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    public static void copyThumbnail(ResourceReference fromPK, ResourceReference toPK) {
        ThumbnailDetail vignette = ThumbnailController.getCompleteThumbnail(new ThumbnailDetail(fromPK.getInstanceId(), Integer.parseInt(fromPK.getId()), 1));
        try {
            if (vignette != null) {
                ThumbnailDetail thumbDetail = new ThumbnailDetail(toPK.getInstanceId(), Integer.parseInt(toPK.getId()), 1);
                if (vignette.getOriginalFileName().startsWith("/")) {
                    thumbDetail.setOriginalFileName(vignette.getOriginalFileName());
                    thumbDetail.setMimeType(vignette.getMimeType());
                } else {
                    String from = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + vignette.getOriginalFileName();
                    String type = FilenameUtils.getExtension((String)vignette.getOriginalFileName());
                    String newOriginalImage = System.currentTimeMillis() + "." + type;
                    String to = ThumbnailController.getImageDirectory(toPK.getInstanceId()) + newOriginalImage;
                    FileRepositoryManager.copyFile(from, to);
                    thumbDetail.setOriginalFileName(newOriginalImage);
                    if (vignette.getCropFileName() != null) {
                        from = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + vignette.getCropFileName();
                        type = FilenameUtils.getExtension((String)vignette.getCropFileName());
                        String newThumbnailImage = System.currentTimeMillis() + "." + type;
                        to = ThumbnailController.getImageDirectory(toPK.getInstanceId()) + newThumbnailImage;
                        FileRepositoryManager.copyFile(from, to);
                        thumbDetail.setCropFileName(newThumbnailImage);
                    }
                    thumbDetail.setMimeType(vignette.getMimeType());
                    thumbDetail.setXLength(vignette.getXLength());
                    thumbDetail.setYLength(vignette.getYLength());
                    thumbDetail.setXStart(vignette.getXStart());
                    thumbDetail.setYStart(vignette.getYStart());
                }
                ThumbnailController.getThumbnailService().createThumbnail(thumbDetail);
            }
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    public static void moveThumbnail(ResourceReference fromPK, ResourceReference toPK) {
        ThumbnailDetail thumbnail = ThumbnailController.getCompleteThumbnail(new ThumbnailDetail(fromPK.getInstanceId(), Integer.parseInt(fromPK.getId()), 1));
        try {
            if (thumbnail != null) {
                if (!thumbnail.getOriginalFileName().startsWith("/")) {
                    String path = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + File.separatorChar + thumbnail.getOriginalFileName();
                    String destinationPath = ThumbnailController.getImageDirectory(toPK.getInstanceId());
                    SilverpeasFile image = SilverpeasFileProvider.getFile(path);
                    image.moveInto(destinationPath);
                    if (thumbnail.getCropFileName() != null) {
                        path = ThumbnailController.getImageDirectory(fromPK.getInstanceId()) + File.separatorChar + thumbnail.getCropFileName();
                        image = SilverpeasFileProvider.getFile(path);
                        image.moveInto(destinationPath);
                    }
                }
                ThumbnailController.getThumbnailService().moveThumbnail(thumbnail, toPK.getInstanceId());
            }
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    protected static void createCropThumbnailFileOnServer(String pathOriginalFile, String pathCropdir, String pathCropFile, ThumbnailDetail thumbnail, int thumbnailWidth, int thumbnailHeight) {
        try {
            File originalFile;
            File cropFile;
            File dir = new File(pathCropdir);
            if (!dir.exists()) {
                FileFolderManager.createFolder(pathCropdir);
            }
            if (!(cropFile = new File(pathCropFile)).exists()) {
                Files.createFile(cropFile.toPath(), new FileAttribute[0]);
            }
            if (!ThumbnailController.croppingWithImageTool(thumbnail, originalFile = new File(pathOriginalFile), cropFile, thumbnailWidth, thumbnailHeight)) {
                ThumbnailController.croppingWithImageIO(thumbnail, originalFile, cropFile, thumbnailWidth, thumbnailHeight);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger(ThumbnailController.class).warn((Throwable)e);
        }
    }

    private static void croppingWithImageIO(ThumbnailDetail thumbnail, File originalFile, File cropFile, int thumbnailWidth, int thumbnailHeight) throws IOException {
        BufferedImage bufferOriginal = ImageIO.read(originalFile);
        BufferedImage cropPicture = bufferOriginal.getSubimage(thumbnail.getXStart(), thumbnail.getYStart(), thumbnail.getXLength(), thumbnail.getYLength());
        BufferedImage cropPictureFinal = new BufferedImage(thumbnailWidth, thumbnailHeight, 1);
        Graphics2D g2 = cropPictureFinal.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(cropPicture, 0, 0, thumbnailWidth, thumbnailHeight, null);
        g2.dispose();
        String extension = FilenameUtils.getExtension((String)originalFile.getName());
        ImageIO.write((RenderedImage)cropPictureFinal, extension, cropFile);
    }

    private static boolean croppingWithImageTool(ThumbnailDetail thumbnail, File originalFile, File cropFile, int thumbnailWidth, int thumbnailHeight) {
        ImageTool imageTool = ImageTool.get();
        if (imageTool.isActivated()) {
            try {
                imageTool.convert(originalFile, cropFile, CropOption.crop(thumbnail.getXLength(), thumbnail.getYLength()).withOffset(thumbnail.getXStart(), thumbnail.getYStart()), new ImageToolDirective[0]);
                imageTool.convert(cropFile, cropFile, Set.of(OrientationOption.auto(), DimensionOption.widthAndHeight(thumbnailWidth, thumbnailHeight)), ImageToolDirective.PREVIEW_WORK, ImageToolDirective.GEOMETRY_SHRINK);
            }
            catch (Exception e) {
                SilverLogger.getLogger(ThumbnailController.class).warn((Throwable)e);
            }
        }
        return cropFile.length() != 0L;
    }

    private static void deleteThumbnailFileOnServer(String componentId, String fileName) {
        String path = ThumbnailController.getImageDirectory(componentId) + fileName;
        try {
            SilverpeasFile image = SilverpeasFileProvider.getFile(path);
            Files.deleteIfExists(image.toPath());
        }
        catch (Exception e) {
            SilverLogger.getLogger(ThumbnailController.class).warn((Throwable)e);
        }
    }

    public static String[] getImageAndMimeType(ThumbnailDetail thumbDetail) {
        try {
            ThumbnailDetail thumbDetailComplete = ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbDetail);
            if (thumbDetailComplete != null) {
                if (thumbDetailComplete.getCropFileName() != null) {
                    return new String[]{thumbDetailComplete.getCropFileName(), thumbDetailComplete.getMimeType()};
                }
                return new String[]{thumbDetailComplete.getOriginalFileName(), thumbDetailComplete.getMimeType()};
            }
            return new String[]{null, null};
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    private static ThumbnailDetail cropThumbnail(ThumbnailDetail thumbnail, int thumbnailWidth, int thumbnailHeight) {
        try {
            ThumbnailDetail thumbDetailComplete = ThumbnailController.getThumbnailService().getCompleteThumbnail(thumbnail);
            if (thumbDetailComplete.getCropFileName() != null) {
                ThumbnailController.deleteThumbnailFileOnServer(thumbnail.getInstanceId(), thumbDetailComplete.getCropFileName());
            } else {
                String extension = FilenameUtils.getExtension((String)thumbDetailComplete.getOriginalFileName());
                String cropFileName = String.valueOf(new Date().getTime()) + "." + extension;
                thumbDetailComplete.setCropFileName(cropFileName);
            }
            String pathCropdir = ThumbnailController.getImageDirectory(thumbnail.getInstanceId());
            String pathOriginalFile = pathCropdir + thumbDetailComplete.getOriginalFileName();
            String pathCropFile = pathCropdir + thumbDetailComplete.getCropFileName();
            ThumbnailController.createCropThumbnailFileOnServer(pathOriginalFile, pathCropdir, pathCropFile, thumbnail, thumbnailWidth, thumbnailHeight);
            thumbDetailComplete.setXStart(thumbnail.getXStart());
            thumbDetailComplete.setXLength(thumbnail.getXLength());
            thumbDetailComplete.setYStart(thumbnail.getYStart());
            thumbDetailComplete.setYLength(thumbnail.getYLength());
            ThumbnailController.getThumbnailService().updateThumbnail(thumbDetailComplete);
            return thumbDetailComplete;
        }
        catch (Exception e) {
            throw new ThumbnailRuntimeException(e);
        }
    }

    private static void createCropFile(int thumbnailWidth, int thumbnailHeight, ThumbnailDetail thumbDetailComplete) throws IOException, ThumbnailException {
        String[] result;
        String pathOriginalFile = ThumbnailController.getImageDirectory(thumbDetailComplete.getInstanceId()) + thumbDetailComplete.getOriginalFileName();
        if (thumbnailWidth == -1 && thumbnailHeight != -1) {
            result = ImageUtil.getWidthAndHeightByHeight(new File(pathOriginalFile), thumbnailHeight);
            thumbnailWidth = Integer.parseInt(result[0]);
            thumbnailHeight = Integer.parseInt(result[1]);
        } else if (thumbnailHeight == -1 && thumbnailWidth != -1) {
            result = ImageUtil.getWidthAndHeightByWidth(new File(pathOriginalFile), thumbnailWidth);
            thumbnailWidth = Integer.parseInt(result[0]);
            thumbnailHeight = Integer.parseInt(result[1]);
        } else if (thumbnailHeight == -1) {
            result = ImageUtil.getWidthAndHeight(new File(pathOriginalFile));
            thumbnailWidth = Integer.parseInt(result[0]);
            thumbnailHeight = Integer.parseInt(result[1]);
        }
        String extension = FilenameUtils.getExtension((String)thumbDetailComplete.getOriginalFileName());
        String cropFileName = String.valueOf(new Date().getTime() + 2L) + "." + extension;
        thumbDetailComplete.setCropFileName(cropFileName);
        ThumbnailController.cropFromPath(pathOriginalFile, thumbDetailComplete, thumbnailHeight, thumbnailWidth);
    }

    protected static void cropFromPath(String pathOriginalFile, ThumbnailDetail thumbDetailComplete, int thumbnailHeight, int thumbnailWidth) throws IOException, ThumbnailException {
        File originalFile = new File(pathOriginalFile);
        BufferedImage bufferOriginal = ImageIO.read(originalFile);
        if (bufferOriginal == null) {
            throw new ThumbnailException("Not an image", new String[0]);
        }
        thumbDetailComplete.setXStart(0);
        thumbDetailComplete.setYStart(0);
        thumbDetailComplete.setXLength(bufferOriginal.getWidth());
        thumbDetailComplete.setYLength(bufferOriginal.getHeight());
        String pathCropFile = ThumbnailController.getImageDirectory(thumbDetailComplete.getInstanceId()) + thumbDetailComplete.getCropFileName();
        ThumbnailController.createCropThumbnailFileOnServer(pathOriginalFile, ThumbnailController.getImageDirectory(thumbDetailComplete.getInstanceId()), pathCropFile, thumbDetailComplete, thumbnailWidth, thumbnailHeight);
        ThumbnailController.getThumbnailService().updateThumbnail(thumbDetailComplete);
    }

    protected static String getImageDirectory(String instanceId) {
        return FileRepositoryManager.getAbsolutePath(instanceId) + publicationSettings.getString("imagesSubDirectory") + File.separatorChar;
    }
}

