/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.parser.tika;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.index.indexing.parser.DefaultParser;
import org.silverpeas.core.index.indexing.parser.Parser;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
@Named(value="tikaParser")
@DefaultParser
public class TikaParser
implements Parser {
    private Tika tika;

    @PostConstruct
    private void initTika() {
        this.tika = new Tika();
    }

    @Override
    public Parser.Context getContext(String path, String encoding) {
        Metadata metadata = new Metadata();
        try {
            Reader reader = this.tika.parse(new File(path), metadata);
            return new Parser.Context(reader, new TikaMetadata(metadata));
        }
        catch (IOException ex) {
            IndexingLogger.indexingLogger().error(ex.getMessage(), (Throwable)ex);
            return new Parser.Context(new StringReader(""), new TikaMetadata(null));
        }
    }

    private static class TikaMetadata
    implements Parser.Metadata {
        private final Metadata metadata;

        private TikaMetadata(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Optional<String> getValue(String key) {
            return this.metadata == null ? Optional.empty() : Optional.ofNullable(this.metadata.get(key)).filter(StringUtil::isDefined);
        }
    }
}

