/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.ical.ical4j;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.ical4j.HtmlProperty;
import org.silverpeas.core.calendar.ical4j.ICal4JDateCodec;
import org.silverpeas.core.calendar.ical4j.ICal4JRecurrenceCodec;
import org.silverpeas.core.importexport.EncodingException;
import org.silverpeas.core.importexport.ical.ICalCodec;
import org.silverpeas.core.importexport.ical.ical4j.OffLineInetAddressHostInfo;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.html.HtmlCleaner;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class ICal4JICalCodec
implements ICalCodec {
    private final OffLineInetAddressHostInfo hostInfo = new OffLineInetAddressHostInfo();
    private final ICal4JDateCodec iCal4JDateCodec;
    private final ICal4JRecurrenceCodec iCal4JRecurrenceCodec;

    @Inject
    public ICal4JICalCodec(ICal4JDateCodec iCal4JDateCodec, ICal4JRecurrenceCodec iCal4JRecurrenceCodec) {
        this.iCal4JDateCodec = iCal4JDateCodec;
        this.iCal4JRecurrenceCodec = iCal4JRecurrenceCodec;
    }

    @Override
    public String encode(List<CalendarEvent> events) {
        if (events == null || events.isEmpty()) {
            throw new IllegalArgumentException("The calendar events must be defined to encode them");
        }
        Calendar calendarIcs = new Calendar();
        calendarIcs.getProperties().add((Property)new ProdId("-//Silverpeas//iCal4j 1.1//FR"));
        calendarIcs.getProperties().add((Property)Version.VERSION_2_0);
        calendarIcs.getProperties().add((Property)CalScale.GREGORIAN);
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        VTimeZone tz = registry.getTimeZone("Europe/Paris").getVTimeZone();
        calendarIcs.getComponents().add((Object)tz);
        ArrayList<VEvent> iCalEvents = new ArrayList<VEvent>();
        ByteArrayOutputStream output = new ByteArrayOutputStream(10240);
        for (Object event : events) {
            Date startDate = this.iCal4JDateCodec.encode(event.getStartDate());
            Date endDate = this.iCal4JDateCodec.encode(event.getEndDate());
            VEvent iCalEvent = this.getICalEvent((CalendarEvent)event, startDate, endDate);
            iCalEvents.add(iCalEvent);
        }
        calendarIcs.getComponents().addAll(iCalEvents);
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            Object event;
            outputter.output(calendarIcs, (OutputStream)output);
            event = output.toString(Charsets.UTF_8);
            return event;
        }
        catch (Exception ex) {
            throw new EncodingException("The encoding of the events in iCal formatted text has failed!", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    @Nonnull
    private VEvent getICalEvent(CalendarEvent event, Date startDate, Date endDate) {
        TextList categoryList;
        VEvent iCalEvent = event.isOnAllDay() && startDate.equals((Object)endDate) ? new VEvent(startDate, event.getTitle()) : new VEvent(startDate, endDate, event.getTitle());
        iCalEvent.getProperties().add((Property)this.generateUid(event));
        if (event.isRecurrent()) {
            Recur recur = this.iCal4JRecurrenceCodec.encode(event);
            iCalEvent.getProperties().add((Property)new RRule(recur));
            iCalEvent.getProperties().add((Property)new ExDate(this.iCal4JRecurrenceCodec.convertExceptionDates(event)));
        }
        if (StringUtil.isDefined((String)event.getDescription())) {
            HtmlCleaner cleaner = new HtmlCleaner();
            String plainText = "";
            try {
                plainText = cleaner.cleanHtmlFragment(event.getDescription());
            }
            catch (Exception exception) {
                // empty catch block
            }
            iCalEvent.getProperties().add((Property)new Description(plainText));
            iCalEvent.getProperties().add((Property)new HtmlProperty(event.getDescription()));
        }
        iCalEvent.getProperties().add((Property)new Clazz(event.getVisibilityLevel().name()));
        iCalEvent.getProperties().add((Property)new Priority(event.getPriority().getICalLevel()));
        Optional<String> location = Optional.ofNullable(event.getLocation());
        location.ifPresent(s -> iCalEvent.getProperties().add((Property)new Location(s)));
        Optional url = event.getAttributes().get("url");
        if (url.isPresent()) {
            try {
                iCalEvent.getProperties().add((Property)new Url(new URI((String)url.get())));
            }
            catch (URISyntaxException ex) {
                throw new EncodingException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (!(categoryList = new TextList(event.getCategories().asArray())).isEmpty()) {
            iCalEvent.getProperties().add((Property)new Categories(categoryList));
        }
        event.getAttendees().forEach(a2 -> {
            try {
                iCalEvent.getProperties().add((Property)new Attendee(a2.getId()));
            }
            catch (URISyntaxException ex) {
                throw new EncodingException("Malformed attendee URI: " + a2, (Throwable)ex);
            }
        });
        return iCalEvent;
    }

    private Uid generateUid(CalendarEvent event) {
        StringBuilder b = new StringBuilder();
        b.append(event.getId());
        if (StringUtil.isDefined((String)this.hostInfo.getHostName())) {
            b.append('@');
            b.append(this.hostInfo.getHostName());
        }
        return new Uid(b.toString());
    }
}

