/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.contentcontainer.content;

import java.util.List;
import java.util.Optional;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

public interface SilverpeasContentManager {
    public static Optional<SilverpeasContentManager> getByInstanceId(String componentInstanceId) {
        try {
            SilverpeasContentManager contentManager = ContentManagementEngineProvider.getContentManagementEngine().getContentPeas(componentInstanceId).getContentManager();
            return Optional.ofNullable(contentManager);
        }
        catch (SilverpeasException e) {
            SilverLogger.getLogger(SilverpeasContentManager.class).silent((Throwable)e);
            return Optional.empty();
        }
    }

    public List<SilverContentInterface> getSilverContentByReference(List<ResourceReference> var1, String var2);

    public <T extends Contribution> int getSilverContentId(T var1);

    public <T extends Contribution> int getOrCreateSilverContentId(T var1);

    public int getOrCreateSilverContentId(String var1, String var2);

    public <T extends Contribution> int createSilverContent(T var1, String var2);

    public void deleteSilverContent(String var1, String var2);
}

