/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service.directive;

import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.silverpeas.core.contribution.content.wysiwyg.service.directive.AbstractDirective;
import org.silverpeas.core.util.URLUtil;

public class MailLinkCssApplierDirective
extends AbstractDirective {
    @Override
    public void prepareReplacements(Source source, Map<String, String> replacements) {
        List linkElements = source.getAllElements("a");
        for (Element currentLink : linkElements) {
            StartTag linkStartTag = currentLink.getStartTag();
            if (!this.isCompliantHref(linkStartTag)) continue;
            String href = this.getHrefAttribute(linkStartTag);
            String newHref = URLUtil.getCurrentServerURL().replaceFirst("[/]+$", "") + href;
            this.apply(linkStartTag, newHref, replacements);
        }
    }

    private void apply(StartTag linkStartTag, String newHref, Map<String, String> replacements) {
        String linkStartTagAsString = linkStartTag.toString();
        if (replacements.containsKey(linkStartTagAsString)) {
            return;
        }
        String href = this.getHrefAttribute(linkStartTag);
        String newLinkStartTagAsString = linkStartTagAsString.replace(href, newHref);
        replacements.put(linkStartTagAsString, newLinkStartTagAsString);
    }

    private boolean isCompliantHref(StartTag linkStartTag) {
        return this.getHrefAttribute(linkStartTag).startsWith(URLUtil.getApplicationURL());
    }

    private String getHrefAttribute(StartTag linkStartTag) {
        return linkStartTag.getURIAttributes().stream().map(Attribute::getValueSegment).map(Segment::toString).findFirst().orElse("");
    }
}

