/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.xhtml.div;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.GroupField;
import org.silverpeas.core.html.plugin.UserGroupSelectProducer;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.util.StringUtil;

public class GroupFieldDisplayer
extends AbstractFieldDisplayer<GroupField> {
    private static final int NB_HTML_ELEMENTS = 2;

    public String[] getManagedTypes() {
        return new String[]{"group"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        GroupFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, GroupField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        boolean writable = !template.isHidden() && !template.isDisabled() && !template.isReadOnly();
        String language = pageContext.getLanguage();
        String selectGroupLab = Util.getString("groupPanel", language);
        String deleteGroupLab = Util.getString("clearGroup", language);
        String fieldName = template.getFieldName();
        String rootContainerId = "select-user-group-" + fieldName + UUID.randomUUID();
        String groupId = field.getTypeName().equals("group") ? field.getGroupId() : "";
        UserGroupSelectProducer selectGroup = UserGroupSelectProducer.withContainerId(rootContainerId).withGroupInputName(fieldName).selectionOf(UserGroupSelectProducer.SelectionType.GROUP).multiple(false).readOnly(!writable).hidden(template.isHidden()).withGroupIds(groupId).withUserPanelButtonLabel(selectGroupLab).withRemoveButtonLabel(deleteGroupLab);
        if (writable) {
            boolean groupsOfInstanceOnly;
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            String roles = parameters.get("roles");
            boolean bl = groupsOfInstanceOnly = StringUtil.getBooleanValue((String)parameters.get("groupsOfInstanceOnly")) || StringUtil.isDefined((String)roles);
            if (groupsOfInstanceOnly) {
                selectGroup.filterOnComponentId(pageContext.getComponentId());
            }
            selectGroup.filterOnRoles(roles);
            selectGroup.mandatory(template.isMandatory() && pageContext.useMandatory());
        }
        out.println(new div().setID(rootContainerId));
        out.println(selectGroup.produce());
    }

    @Override
    public List<String> update(String newId, GroupField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (field.getTypeName().equals("group")) {
            if (!StringUtil.isDefined((String)newId)) {
                field.setNull();
            } else {
                field.setGroupId(newId);
            }
        } else {
            throw new FormException("Incorrect field value type. Expected {0}", "group");
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }

    @Override
    public List<String> update(List<FileItem> items, GroupField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String itemName = template.getFieldName();
        String value = FileUploadUtil.getParameter(items, itemName);
        if (pageContext.getUpdatePolicy() == 1 && !StringUtil.isDefined((String)value)) {
            return new ArrayList<String>();
        }
        return this.update(value, field, template, pageContext);
    }
}

