/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FieldValue;
import org.silverpeas.core.contribution.content.form.FieldValuesTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.contribution.content.form.record.Parameter;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

public class CheckBoxDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println(" var checked = false;\n");
            out.println(" for (var i = 0; i < " + this.getNbHtmlObjectsDisplayed(template, pagesContext) + "; i++) {\n");
            out.println("   if (document.getElementsByName('" + fieldName + "')[i].checked) {\n");
            out.println("     checked = true;\n");
            out.println("   }\n");
            out.println(" }\n");
            out.println(" if(!ignoreMandatory && checked == false) {\n");
            out.println("   errorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n \";");
            out.println("   errorNb++;");
            out.println(" }");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String language = pageContext.getLanguage();
        List<String> valuesFromDB = CheckBoxDisplayer.getSelectedValues(field, language);
        StringBuilder html2 = new StringBuilder();
        Map<String, String> parameters = template.getParameters(language);
        String cssClass = CheckBoxDisplayer.getStyleClasses(parameters);
        int cols = this.getColumnSize(parameters);
        FieldValuesTemplate valuesTemplate = template.getFieldValuesTemplate(language);
        String defaultValue = this.getDefaultValue(template, pageContext);
        if (valuesTemplate.isEmpty()) {
            valuesTemplate.withAsValue(defaultValue, defaultValue);
        }
        GenerationParameters params = new GenerationParameters();
        params.fieldTemplate = template;
        params.fieldValuesTemplate = valuesTemplate;
        params.cssClass = cssClass;
        params.valuesFromDB = valuesFromDB;
        params.defaultValue = defaultValue;
        params.cols = cols;
        this.generateHTML(html2, params, pageContext);
        out.println(html2);
    }

    private int getColumnSize(Map<String, String> parameters) {
        int cols = -1;
        try {
            if (parameters.containsKey("cols")) {
                cols = Integer.parseInt(parameters.get("cols"));
            }
        }
        catch (NumberFormatException nfe) {
            SilverLogger.getLogger((Object)this).error("Illegal Parameter cols: {0}", new Object[]{parameters.get("cols")});
        }
        return cols;
    }

    @Nullable
    private static String getStyleClasses(Map<String, String> parameters) {
        Object cssClass = null;
        if (parameters.containsKey("class") && StringUtil.isDefined((String)(cssClass = parameters.get("class")))) {
            cssClass = "class=\"" + (String)cssClass + "\"";
        }
        return cssClass;
    }

    @NonNull
    private static List<String> getSelectedValues(TextField field, String language) {
        if (!field.isNull()) {
            String selectedValues = field.getValue(language);
            return Parameter.decode(selectedValues);
        }
        return List.of();
    }

    private void generateHTML(StringBuilder html2, GenerationParameters params, PagesContext pageContext) {
        html2.append("<table border=\"0\">");
        params.nbOfTokenToDisplay = this.getNbHtmlObjectsDisplayed(params.fieldTemplate, pageContext);
        Mutable col = Mutable.of((Object)0);
        Mutable idx = Mutable.of((Object)0);
        params.fieldValuesTemplate.apply(v -> col.set((Object)CheckBoxDisplayer.generateHTMLValue(html2, v, params, pageContext, (Integer)col.get(), (Integer)idx.get())));
        if ((Integer)col.get() != 0) {
            html2.append("</tr>");
        }
        html2.append("</table>");
    }

    private static int generateHTMLValue(StringBuilder html2, FieldValue fieldValue, GenerationParameters parameters, PagesContext pageContext, int rowIndex, int colIndex) {
        boolean mustBeChecked;
        if (colIndex == 0) {
            html2.append("<tr>");
        }
        String fieldName = parameters.fieldTemplate.getFieldName();
        ++colIndex;
        html2.append("<td>");
        html2.append("<input type=\"checkbox\" id=\"").append(fieldName).append("_").append(rowIndex);
        html2.append("\" name=\"").append(fieldName).append("\" value=\"").append(fieldValue.getKey()).append("\" ");
        if (StringUtil.isDefined((String)parameters.cssClass)) {
            html2.append(parameters.cssClass);
        }
        if (parameters.fieldTemplate.isDisabled() || parameters.fieldTemplate.isReadOnly()) {
            html2.append(" disabled=\"disabled\" ");
        }
        boolean bl = mustBeChecked = parameters.valuesFromDB.isEmpty() && !pageContext.isIgnoreDefaultValues() && (fieldValue.getKey().equals(parameters.defaultValue) || fieldValue.getLabel().equals(parameters.defaultValue));
        if (parameters.valuesFromDB.contains(fieldValue.getKey())) {
            mustBeChecked = true;
        }
        if (mustBeChecked) {
            html2.append(" checked=\"checked\" ");
        }
        html2.append("/>&nbsp;").append(fieldValue.getLabel());
        if (rowIndex == parameters.nbOfTokenToDisplay - 1 && parameters.fieldTemplate.isMandatory() && !parameters.fieldTemplate.isDisabled() && !parameters.fieldTemplate.isReadOnly() && !parameters.fieldTemplate.isHidden() && pageContext.useMandatory()) {
            html2.append(Util.getMandatorySnippet());
        }
        html2.append("</td>");
        html2.append("\n");
        if (colIndex == parameters.cols) {
            html2.append("</tr>");
            colIndex = 0;
        }
        return colIndex;
    }

    @Override
    public List<String> update(List<FileItem> items, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        StringBuilder value = new StringBuilder();
        Iterator<FileItem> iter = items.iterator();
        String parameterName = template.getFieldName();
        while (iter.hasNext()) {
            FileItem item = iter.next();
            if (!parameterName.equals(item.getFieldName())) continue;
            if (value.length() > 0) {
                value.append("##");
            }
            value.append(item.getString());
        }
        if (pageContext.getUpdatePolicy() == 1 && value.length() == 0) {
            return new ArrayList<String>();
        }
        return this.update(value.toString(), field, template, pageContext);
    }

    @Override
    public List<String> update(String valuesToInsert, TextField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        CheckBoxDisplayer.setFieldValue(valuesToInsert, field, pagesContext);
        return new ArrayList<String>();
    }

    static void setFieldValue(String valuesToInsert, TextField field, PagesContext pagesContext) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", "text");
        }
        if (!field.acceptValue(valuesToInsert, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "text");
        }
        field.setValue(valuesToInsert, pagesContext.getLanguage());
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return template.getFieldValuesTemplate(pagesContext.getLanguage()).size();
    }

    private static class GenerationParameters {
        FieldTemplate fieldTemplate;
        FieldValuesTemplate fieldValuesTemplate;
        String cssClass;
        List<String> valuesFromDB;
        String defaultValue;
        int cols;
        int nbOfTokenToDisplay;

        private GenerationParameters() {
        }
    }
}

