/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import java.util.Objects;
import org.silverpeas.core.contribution.attachment.model.UnlockOption;

public class UnlockContext {
    private int options = 0;
    private final String attachmentId;
    private final String userId;
    private final String comment;
    private final String lang;

    public UnlockContext(String attachmentId, String userId, String lang) {
        this.attachmentId = attachmentId;
        this.userId = userId;
        this.lang = lang;
        this.comment = "";
    }

    public UnlockContext(String attachmentId, String userId, String lang, String comment) {
        this.attachmentId = attachmentId;
        this.userId = userId;
        this.lang = lang;
        this.comment = comment;
    }

    public void addOption(UnlockOption option) {
        this.options = option.addOption(this.options);
    }

    public void removeOption(UnlockOption option) {
        this.options = option.removeOption(this.options);
    }

    public boolean isPublicVersion() {
        return !UnlockOption.PRIVATE_VERSION.isSelected(this.options);
    }

    public boolean isForce() {
        return UnlockOption.FORCE.isSelected(this.options);
    }

    public boolean isUpload() {
        return UnlockOption.UPLOAD.isSelected(this.options);
    }

    public boolean isWebdav() {
        return UnlockOption.WEBDAV.isSelected(this.options);
    }

    public boolean isPrivateVersion() {
        return UnlockOption.PRIVATE_VERSION.isSelected(this.options);
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLang() {
        return this.lang;
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.options;
        hash = 29 * hash + (this.attachmentId != null ? this.attachmentId.hashCode() : 0);
        hash = 29 * hash + (this.userId != null ? this.userId.hashCode() : 0);
        hash = 29 * hash + (this.comment != null ? this.comment.hashCode() : 0);
        hash = 29 * hash + (this.lang != null ? this.lang.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnlockContext other = (UnlockContext)obj;
        if (this.options != other.options) {
            return false;
        }
        if (!Objects.equals(this.attachmentId, other.attachmentId)) {
            return false;
        }
        if (!Objects.equals(this.userId, other.userId)) {
            return false;
        }
        if (!Objects.equals(this.comment, other.comment)) {
            return false;
        }
        return Objects.equals(this.lang, other.lang);
    }
}

