/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import javax.inject.Named;
import javax.inject.Singleton;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.reminder.BackgroundReminderProcess;
import org.silverpeas.core.reminder.DefaultContributionReminderUserNotification;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderProcessName;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Named(value="CalendarEventUserNotificationReminderProcess")
@Singleton
public class CalendarEventUserNotificationReminder
implements BackgroundReminderProcess {
    static final String PROCESS_NAME = "CalendarEventUserNotification";
    public static final ReminderProcessName CALENDAR_EVENT_USER_NOTIFICATION = () -> "CalendarEventUserNotification";

    public ReminderProcessName getName() {
        return CALENDAR_EVENT_USER_NOTIFICATION;
    }

    public void performWith(Reminder reminder) {
        new UserNotification(reminder).build().send();
    }

    static class UserNotification
    extends DefaultContributionReminderUserNotification {
        private CalendarEventOccurrence occurrence;
        private ZoneId calendarZoneId;

        UserNotification(Reminder reminder) {
            super(reminder);
        }

        private CalendarEventOccurrence getOccurrence() {
            if (this.occurrence == null) {
                CalendarEvent calendarEvent = (CalendarEvent)this.getResource();
                this.calendarZoneId = calendarEvent.getCalendar().getZoneId();
                OffsetDateTime occStartDate = calendarEvent.isOnAllDay() ? LocalDate.from(this.normalizeTemporal(this.getScheduledDateTimeWithZeroDuration())) : OffsetDateTime.from(this.getScheduledDateTimeWithZeroDuration());
                this.occurrence = (CalendarEventOccurrence)CalendarEventOccurrence.getBy((CalendarEvent)calendarEvent, (Temporal)occStartDate).orElseThrow(() -> new SilverpeasRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"occurrence from event and date", (Object)(calendarEvent.getId() + " and " + occStartDate))));
                this.setResource(this.occurrence);
            }
            return this.occurrence;
        }

        @Override
        protected Temporal computeReminderContributionStart() {
            return this.normalizeTemporal(this.getOccurrence().getStartDate());
        }

        @Override
        protected Temporal computeReminderContributionEnd() {
            Temporal temporal = this.normalizeTemporal(this.getOccurrence().getEndDate());
            return this.getOccurrence().isOnAllDay() ? ((LocalDate)temporal).minusDays(1L) : temporal;
        }

        @Override
        protected ZoneId getZoneIdForNormalization() {
            return this.calendarZoneId;
        }

        @Override
        protected void performTemplateData(LocalizedContribution localizedContribution, SilverpeasTemplate template) {
            super.performTemplateData(localizedContribution, template);
            template.setAttribute("contributionType_CalendarEvent", (Object)true);
        }

        @Override
        protected boolean isUserCanBeNotified(String userId) {
            if (PersonalComponentInstance.from(this.getComponentInstanceId()).isPresent()) {
                return true;
            }
            return super.isUserCanBeNotified(userId);
        }
    }
}

