/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.InternalAttendee;

public class CalendarEventUtil {
    private CalendarEventUtil() {
    }

    public static String formatTitle(CalendarComponent component, String componentInstanceId, boolean canBeAccessed) {
        Object title;
        Object object = title = canBeAccessed ? component.getTitle() : null;
        if (!componentInstanceId.equals(component.getCalendar().getComponentInstanceId())) {
            title = title != null ? (String)title + "\n" : "";
            title = (String)title + "(" + component.getCalendar().getTitle() + ")";
        }
        return title;
    }

    public static Temporal getDateWithOffset(CalendarComponent component, Temporal temporal) {
        return CalendarEventUtil.getDateWithOffset(component, temporal, null);
    }

    public static Temporal getDateWithOffset(CalendarComponent component, Temporal temporal, ZoneId zoneId) {
        ZoneId toZoneId = zoneId != null ? zoneId : component.getCalendar().getZoneId();
        return component.getPeriod().isInDays() ? temporal : ((OffsetDateTime)temporal).atZoneSameInstant(toZoneId).toOffsetDateTime();
    }

    public static String formatDateWithOffset(CalendarComponent component, Temporal temporal, ZoneId zoneId) {
        return CalendarEventUtil.getDateWithOffset(component, temporal, zoneId).toString();
    }

    public static Attendee asAttendee(User user, CalendarComponent component) {
        return InternalAttendee.fromUser((User)user).to(component);
    }
}

