/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.component.dao.CommonDAO;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.CollectionUtil;

@Repository
public class RoleDAO
extends CommonDAO {
    private static final String USERROLE_COLUMNS = "id,instanceId,name,roleName,description,isInherited,objectId,objecttype";
    private static final String FROM_GROUP_RELATION = " from st_userrole r, st_userrole_group_rel gr";
    private static final String WHERE_ID_EQUALS_USERROLEID = " where r.id=gr.userroleid";
    private static final String AND_GROUP_ID_IN = " and gr.groupId IN (";
    private static final String ROLE_INSTANCE_ID = "r.instanceId";
    private static final String SELECT = "select ";
    private static final String FROM_USER_RELATION = " from st_userrole r, st_userrole_user_rel ur";
    private static final String WHERE_ID_EQUALS_TO_USERROLEID = " where r.id=ur.userroleid";
    private static final String AND_USER_ID_EQUALS_TO_GIVEN_VALUE = " and ur.userId = ? ";
    private static final String QUERY_ALL_USER_ROLES = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_user_rel ur where r.id=ur.userroleid and r.objectId is null  and ur.userId = ? ";
    private static final String QUERY_ALL_USER_COMPONENT_OBJECT_ROLES = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_user_rel ur where r.id=ur.userroleid and r.objectId is not null  and ur.userId = ? ";

    private List<UserRoleRow> getRoles(Connection con, int userId) throws SQLException {
        return this.getUserRoleRows(con, QUERY_ALL_USER_ROLES, userId);
    }

    private List<UserRoleRow> getUserRoleRows(Connection con, String queryAllUserRoles, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        try (PreparedStatement stmt = con.prepareStatement(queryAllUserRoles);){
            stmt.setInt(1, userId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    roles.add(UserRoleRow.fetch(rs));
                }
            }
            ArrayList<UserRoleRow> arrayList = roles;
            return arrayList;
        }
    }

    public List<UserRoleRow> getAllComponentObjectRoles(Connection con, List<String> groupIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            roles.addAll(this.getAllComponentObjectRolesForGroups(con, groupIds));
        }
        if (userId != -1) {
            roles.addAll(this.getAllComponentObjectRolesForUser(con, userId));
        }
        return roles;
    }

    private List<UserRoleRow> getAllComponentObjectRolesForUser(Connection con, int userId) throws SQLException {
        return this.getUserRoleRows(con, QUERY_ALL_USER_COMPONENT_OBJECT_ROLES, userId);
    }

    private List<UserRoleRow> getRoles(Connection con, List<String> groupIds) throws SQLException {
        String query = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_group_rel gr where r.id=gr.userroleid and r.objectId is null  and gr.groupId IN (" + RoleDAO.list2String(groupIds) + ")";
        return this.getUserRoleRows(con, query);
    }

    @Nonnull
    private List<UserRoleRow> getUserRoleRows(Connection con, String query) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        try (PreparedStatement stmt = con.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                roles.add(UserRoleRow.fetch(rs));
            }
        }
        return roles;
    }

    private List<UserRoleRow> getAllComponentObjectRolesForGroups(Connection con, List<String> groupIds) throws SQLException {
        String query = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_group_rel gr where r.id=gr.userroleid and r.objectId is not null  and gr.groupId IN (" + RoleDAO.list2String(groupIds) + ")";
        return this.getUserRoleRows(con, query);
    }

    public List<UserRoleRow> getRoles(Connection con, List<String> groupIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            roles.addAll(this.getRoles(con, groupIds));
        }
        if (userId != -1) {
            roles.addAll(this.getRoles(con, userId));
        }
        return roles;
    }

    public List<UserRoleRow> getRoles(Connection con, List<String> groupIds, int userId, Collection<Integer> instanceIds) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            roles.addAll(this.getGroupRoles(con, ProfiledObjectIds.none(), instanceIds, groupIds));
        }
        if (userId != -1) {
            roles.addAll(this.getUserRoles(con, ProfiledObjectIds.none(), instanceIds, userId));
        }
        return roles;
    }

    public List<UserRoleRow> getRoles(Connection con, ProfiledObjectIds profiledObjectIds, Collection<Integer> instanceIds, List<String> groupIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            roles.addAll(this.getGroupRoles(con, profiledObjectIds, instanceIds, groupIds));
        }
        if (userId != -1) {
            roles.addAll(this.getUserRoles(con, profiledObjectIds, instanceIds, userId));
        }
        return roles;
    }

    private List<UserRoleRow> getGroupRoles(Connection con, ProfiledObjectIds profiledObjectIds, Collection<Integer> instanceIds, List<String> groupIds) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        List groupIdsAsInt = groupIds.stream().map(Integer::parseInt).collect(Collectors.toList());
        ProfiledObjectType type = profiledObjectIds.getType();
        if (type == ProfiledObjectType.NONE || profiledObjectIds.typeFilledOnly()) {
            JdbcSqlQuery.executeBySplittingOn(groupIdsAsInt, (groupIdBatch, ignore) -> JdbcSqlQuery.executeBySplittingOn((Collection)instanceIds, (instanceIdBatch, ignoreToo) -> this.getQueryCommons(FROM_GROUP_RELATION, WHERE_ID_EQUALS_USERROLEID, profiledObjectIds, type).and("gr.groupId", new Object[0]).in(groupIdBatch).and(ROLE_INSTANCE_ID, new Object[0]).in(instanceIdBatch).executeWith(con, r -> roles.add(UserRoleRow.fetch((ResultSet)r)))));
        } else {
            JdbcSqlQuery.executeBySplittingOn((Collection)profiledObjectIds, (profileIdBatch, ignore) -> JdbcSqlQuery.executeBySplittingOn((Collection)groupIdsAsInt, (groupIdBatch, ignoreToo) -> JdbcSqlQuery.executeBySplittingOn((Collection)instanceIds, (instanceIdBatch, ignoreAlsoToo) -> this.getQueryCommons(FROM_GROUP_RELATION, WHERE_ID_EQUALS_USERROLEID, profileIdBatch, type).and("gr.groupId", new Object[0]).in(groupIdBatch).and(ROLE_INSTANCE_ID, new Object[0]).in(instanceIdBatch).executeWith(con, r -> roles.add(UserRoleRow.fetch((ResultSet)r))))));
        }
        return roles;
    }

    private List<UserRoleRow> getUserRoles(Connection con, ProfiledObjectIds profiledObjectIds, Collection<Integer> instanceIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        ProfiledObjectType type = profiledObjectIds.getType();
        if (type == ProfiledObjectType.NONE || profiledObjectIds.typeFilledOnly()) {
            JdbcSqlQuery.executeBySplittingOn(instanceIds, (idBatch, ignore) -> this.getQueryCommons(FROM_USER_RELATION, WHERE_ID_EQUALS_TO_USERROLEID, profiledObjectIds, type).and("ur.userId = ?", new Object[]{userId}).and(ROLE_INSTANCE_ID, new Object[0]).in(idBatch).executeWith(con, r -> roles.add(UserRoleRow.fetch((ResultSet)r))));
        } else {
            JdbcSqlQuery.executeBySplittingOn((Collection)profiledObjectIds, (profileIdBatch, ignore) -> JdbcSqlQuery.executeBySplittingOn((Collection)instanceIds, (instanceIdBatch, ignoreToo) -> this.getQueryCommons(FROM_USER_RELATION, WHERE_ID_EQUALS_TO_USERROLEID, profileIdBatch, type).and("ur.userId = ?", new Object[]{userId}).and(ROLE_INSTANCE_ID, new Object[0]).in(instanceIdBatch).executeWith(con, r -> roles.add(UserRoleRow.fetch((ResultSet)r)))));
        }
        return roles;
    }

    private JdbcSqlQuery getQueryCommons(String joins, String clauses, Collection<String> objectIds, ProfiledObjectType profiledObjectType) {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"DISTINCT id,instanceId,name,roleName,description,isInherited,objectId,objecttype").addSqlPart(joins, new Object[0]).addSqlPart(clauses, new Object[0]);
        if (CollectionUtil.isNotEmpty(objectIds)) {
            query.and("r.objectId", new Object[0]).in((Collection)objectIds.stream().map(Integer::parseInt).collect(Collectors.toSet()));
        }
        if (profiledObjectType != ProfiledObjectType.NONE) {
            query.and("r.objectType = ?", new Object[]{profiledObjectType.getCode()});
        } else {
            query.andNull("r.objectType");
        }
        return query;
    }
}

