/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.silverpeas.core.admin.persistence.KeyStoreRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.annotation.Repository;

@Repository
public class KeyStoreTable
extends Table<KeyStoreRow> {
    private static final String KEYSTORE_COLUMNS = "userKey, login, domainId";
    private static final String SELECT_RECORD_BY_KEY = "select userKey, login, domainId from ST_KeyStore where userKey = ?";
    private static final String DELETE_RECORD = "delete from ST_KeyStore where userKey = ?";

    KeyStoreTable() {
        super("ST_KeyStore");
    }

    protected KeyStoreRow fetchKeyStore(ResultSet rs) throws SQLException {
        KeyStoreRow k = new KeyStoreRow();
        k.key = rs.getInt("userKey");
        k.login = rs.getString("login");
        k.domainId = rs.getInt("domainId");
        return k;
    }

    public KeyStoreRow getRecordByKey(int nKey) throws SQLException {
        return (KeyStoreRow)this.getUniqueRow(SELECT_RECORD_BY_KEY, nKey);
    }

    public void removeKeyStoreRecord(int nKey) throws SQLException {
        this.updateRelation(DELETE_RECORD, nKey);
    }

    protected KeyStoreRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchKeyStore(rs);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, KeyStoreRow row) {
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, KeyStoreRow row) {
    }
}

