/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.repository;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.inject.Singleton;
import org.silverpeas.core.admin.domain.exception.SQLDomainDAOException;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.repository.SQLDomainRepository;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQueries;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
@Repository
public class SQLInternalDomainRepository
implements SQLDomainRepository {
    private static final String DOMAIN_TABLE = "Domain";
    private static final String INT_NOT_NULL = "int NOT NULL";
    private static final String PROPERTY = "property_";
    private static final String PASS_PROP = "password";

    @Override
    public void createDomainStorage(Domain domain) throws SQLDomainDAOException {
        String domainName = domain.getName();
        try {
            JdbcSqlQueries queries = new JdbcSqlQueries();
            queries.add((Object)this.generateUserTableCreateStatement(domainName));
            queries.add((Object)this.generateGroupTableCreateStatement(domainName));
            queries.add((Object)this.generateGroupUserRelTableCreateStatement(domainName));
            queries.execute();
        }
        catch (Exception e) {
            throw new SQLDomainDAOException("SQLInternalDomainDAO.createDomainStorage", "admin.CANNOT_CREATE_DOMAIN_STORAGE", e);
        }
    }

    private JdbcSqlQuery generateGroupUserRelTableCreateStatement(String domainName) {
        return JdbcSqlQuery.createTable((String)(DOMAIN_TABLE + domainName + "_Group_User_Rel")).addField("groupId", INT_NOT_NULL).addField("userId", INT_NOT_NULL);
    }

    private JdbcSqlQuery generateGroupTableCreateStatement(String domainName) {
        return JdbcSqlQuery.createTable((String)(DOMAIN_TABLE + domainName + "_Group")).addField("id", INT_NOT_NULL).addField("superGroupId", "int NULL").addField("name", "varchar(100) NOT NULL").addField("description", "varchar(400) NULL").addField("grSpecificInfo", "varchar(50) NULL");
    }

    private JdbcSqlQuery generateUserTableCreateStatement(String domainName) throws IOException {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(FileRepositoryManager.getDomainPropertiesPath(domainName));){
            props.load(fis);
        }
        int numberOfColumns = Integer.parseInt(props.getProperty("property.Number"));
        JdbcSqlQuery userTable = JdbcSqlQuery.createTable((String)(DOMAIN_TABLE + domainName + "_User "));
        userTable.addField("id", INT_NOT_NULL).addField("firstName", "varchar(100) NULL").addField("lastName", "varchar(100) NULL").addField("email", "varchar(200) NULL").addField("login", "varchar(50) NOT NULL").addField(PASS_PROP, "varchar(123) NULL").addField("passwordValid", "char(1) NULL");
        for (int i = 1; i <= numberOfColumns; ++i) {
            String specificColumnType = props.getProperty(PROPERTY + String.valueOf(i) + ".Type");
            String specificColumnName = props.getProperty(PROPERTY + String.valueOf(i) + ".MapParameter");
            String maxLengthPropertyValue = props.getProperty(PROPERTY + String.valueOf(i) + ".MaxLength");
            int specificColumnMaxLength = StringUtil.isInteger((String)maxLengthPropertyValue) ? Integer.parseInt(maxLengthPropertyValue) : 50;
            if ("BOOLEAN".equals(specificColumnType)) {
                userTable.addField(specificColumnName, "int NOT NULL DEFAULT (0)");
                continue;
            }
            userTable.addField(specificColumnName, "varchar(" + specificColumnMaxLength + ") NULL");
        }
        return userTable;
    }

    @Override
    public void deleteDomainStorage(Domain domain) {
        String domainName = domain.getName();
        try {
            JdbcSqlQueries queries = new JdbcSqlQueries();
            queries.add((Object)this.generateUserTableDropStatement(domainName));
            queries.add((Object)this.generateGroupTableDropStatement(domainName));
            queries.add((Object)this.generateGroupUserRelTableDropStatement(domainName));
            queries.execute();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private JdbcSqlQuery generateGroupUserRelTableDropStatement(String domainName) {
        return JdbcSqlQuery.dropTable((String)(DOMAIN_TABLE + domainName + "_Group_User_Rel"));
    }

    private JdbcSqlQuery generateGroupTableDropStatement(String domainName) {
        return JdbcSqlQuery.dropTable((String)(DOMAIN_TABLE + domainName + "_Group"));
    }

    private JdbcSqlQuery generateUserTableDropStatement(String domainName) {
        return JdbcSqlQuery.dropTable((String)(DOMAIN_TABLE + domainName + "_User"));
    }
}

