/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.utility;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.schema.Meta;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.ejb.Stateless;
import javax.ws.rs.core.EntityTag;

@Stateless
public class EtagGenerator {
    public EntityTag generateEtag(ScimResource resource) throws JsonProcessingException, NoSuchAlgorithmException, UnsupportedEncodingException {
        ObjectMapper objectMapper = new ObjectMapper();
        JaxbAnnotationModule jaxbAnnotationModule = new JaxbAnnotationModule();
        objectMapper.registerModule((Module)jaxbAnnotationModule);
        JaxbAnnotationIntrospector jaxbAnnotationIntrospector = new JaxbAnnotationIntrospector(objectMapper.getTypeFactory());
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)jaxbAnnotationIntrospector);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Meta meta = resource.getMeta();
        if (meta == null) {
            meta = new Meta();
        }
        resource.setMeta(null);
        String writeValueAsString = objectMapper.writeValueAsString((Object)resource);
        EntityTag etag = EtagGenerator.hash(writeValueAsString);
        meta.setVersion(etag.getValue());
        resource.setMeta(meta);
        return etag;
    }

    private static EntityTag hash(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(input.getBytes("UTF-8"));
        byte[] hash = digest.digest();
        return new EntityTag(Base64.getEncoder().encodeToString(hash));
    }
}

