/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolServiceConfigurator;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public enum ScheduledThreadPoolResourceDefinition implements ResourceDefinitionProvider,
ScheduledThreadPoolDefinition,
ResourceServiceConfiguratorFactory
{
    EXPIRATION("expiration", 1, 60000L);

    static final PathElement WILDCARD_PATH;
    private final PathElement path;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute keepAliveTime;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ScheduledThreadPoolResourceDefinition(String name, int defaultMinThreads, long defaultKeepaliveTime) {
        this.path = ScheduledThreadPoolResourceDefinition.pathElement(name);
        this.minThreads = new SimpleAttribute((AttributeDefinition)ScheduledThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0), null).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ScheduledThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, null, (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0), InfinispanModel.VERSION_12_0_0).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ScheduledThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepaliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L), null).build());
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder, InfinispanModel deprecation) {
        SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{deprecation != null ? AttributeAccess.Flag.RESTART_RESOURCE_SERVICES : AttributeAccess.Flag.RESTART_NONE})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null));
        return (SimpleAttributeDefinitionBuilder)builder.setValidator(validatorBuilder.configure((AbstractAttributeDefinitionBuilder)builder).build());
    }

    public void register(ManagementResourceRegistration parent) {
        ResourceDescriptionResolver resolver = InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{this.path, ScheduledThreadPoolResourceDefinition.pathElement("*")});
        SimpleResourceDefinition definition = new SimpleResourceDefinition(this.path, resolver);
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)definition);
        ResourceDescriptor descriptor = new ResourceDescriptor(resolver).addAttributes(new Attribute[]{this.minThreads, this.keepAliveTime}).addAlias(this.maxThreads, this.minThreads);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceConfiguratorFactory)this);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
        return new ScheduledThreadPoolServiceConfigurator(this, address);
    }

    public ServiceName getServiceName(PathAddress containerAddress) {
        return CacheContainerResourceDefinition.Capability.CONFIGURATION.getServiceName(containerAddress).append(this.getPathElement().getKeyValuePair());
    }

    @Override
    public Attribute getMinThreads() {
        return this.minThreads;
    }

    @Override
    public Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    static {
        WILDCARD_PATH = ScheduledThreadPoolResourceDefinition.pathElement("*");
    }
}

