/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.patching.metadata.BundledPatch;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class PatchBundleXml_1_0
implements XMLStreamConstants,
XMLElementReader<PatchXml.Result<BundledPatch>>,
XMLElementWriter<BundledPatch> {
    public void readElement(XMLExtendedStreamReader reader, PatchXml.Result<BundledPatch> result) throws XMLStreamException {
        final ArrayList<BundledPatch.BundledPatchEntry> patches = new ArrayList<BundledPatch.BundledPatchEntry>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case PATCH_ELEMENT: {
                    this.parseElement(reader, patches);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult(new BundledPatch(){

            @Override
            public List<BundledPatch.BundledPatchEntry> getPatches() {
                return patches;
            }
        });
    }

    private void parseElement(XMLExtendedStreamReader reader, List<BundledPatch.BundledPatchEntry> patches) throws XMLStreamException {
        String id = null;
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    id = value;
                    continue block4;
                }
                case PATH: {
                    path = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (id == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.ID.name});
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.PATH.name});
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        patches.add(new BundledPatch.BundledPatchEntry(id, path));
    }

    public void writeContent(XMLExtendedStreamWriter writer, BundledPatch bundledPatch) throws XMLStreamException {
        writer.writeStartElement(Element.PATCHES.name);
        writer.writeDefaultNamespace(PatchXml.Namespace.PATCH_BUNDLE_1_0.getNamespace());
        for (BundledPatch.BundledPatchEntry entry : bundledPatch.getPatches()) {
            writer.writeEmptyElement(Element.PATCH_ELEMENT.name);
            writer.writeAttribute(Attribute.ID.name, entry.getPatchId());
            writer.writeAttribute(Attribute.PATH.name, entry.getPatchPath());
        }
        writer.writeEndElement();
    }

    static enum Attribute {
        ID("id"),
        PATH("path"),
        UNKNOWN(null);

        private final String name;
        static Map<String, Attribute> attributes;

        private Attribute(String name) {
            this.name = name;
        }

        static Attribute forName(String name) {
            Attribute attribute = attributes.get(name);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            attributes = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                if (attribute == UNKNOWN) continue;
                attributes.put(attribute.name, attribute);
            }
        }
    }

    static enum Element {
        PATCHES("patches"),
        PATCH_ELEMENT("element"),
        UNKNOWN(null);

        public final String name;
        static Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        static Element forName(String name) {
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            elements = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                if (element == UNKNOWN) continue;
                elements.put(element.name, element);
            }
        }
    }
}

