(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define(["converse"], factory);
    } else {
        factory(converse);
    }
}(this, function (converse) {
  converse.plugins.add("silverpeas-sp-permalink", {
    dependencies: [],
    initialize: function () {
      const _hostPrefixUrl = location.href.replace(/^(http[s]?:\/\/[^/]+).*/g, '$1/');
      const _converse = this._converse;
      const html = converse.env.html;
      _converse.api.listen.on('afterMessageBodyTransformed', function(text) {
        if (text && text.indexOf(_hostPrefixUrl) >= 0) {
          if (Array.isArray(text.references)) {
            const replaceRefs = [];
            text.references.forEach(function(reference, index) {
              const _template = reference.template;
              if (_template && Array.isArray(_template.values) && _template.values.length === 2) {
                const normalized_url = _template.values[0];
                if (normalized_url.startsWith(_hostPrefixUrl) && spWindow.isPermalink(normalized_url)) {
                  const visible_url = _template.values[1];
                  const classes = "sp-permalink";
                  const template = html`<a class="${classes}" target="_blank" rel="noopener" href="${normalized_url}">${visible_url}</a>`;
                  replaceRefs.push({
                    index : index, begin : reference.begin, end : reference.end, template : template
                  });
                }
              }
            });
            replaceRefs.reverse().forEach(function(dateToReplace) {
              text.references.splice(dateToReplace.index, 1);
            });
            replaceRefs.forEach(function(dateToReplace) {
              text.addTemplateResult(dateToReplace.begin, dateToReplace.end, dateToReplace.template);
            });
          }
        }
      });
    }
  });
}));
