/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.servers;

import com.google.api.client.util.SslUtils;
import java.security.GeneralSecurityException;
import java.util.function.UnaryOperator;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.silverpeas.core.chat.ChatServerException;
import org.silverpeas.core.chat.ChatSettings;
import org.silverpeas.core.util.JSONCodec;

public class HttpRequester
implements AutoCloseable {
    private static final String USER_AGENT = "Silverpeas chat client";
    public static final int STATUS_OK = 200;
    public static final int STATUS_FORBIDDEN = 403;
    public static final int STATUS_UNAUTHORIZED = 401;
    public static final int STATUS_CONFLICT = 409;
    public static final int STATUS_CREATED = 201;
    private final Client client;
    private Invocation.Builder builder;
    private final String token;

    public HttpRequester(String authenticationToken) {
        try {
            this.client = ChatSettings.get().isChatServerSafeUrl() ? ClientBuilder.newBuilder().sslContext(SslUtils.trustAllSSLContext()).build() : ClientBuilder.newClient();
        }
        catch (GeneralSecurityException e) {
            throw new ChatServerException(e);
        }
        this.token = authenticationToken;
    }

    public HttpRequester at(String url, String ... path) {
        WebTarget target = this.client.target(url);
        for (String aPath : path) {
            target = target.path(aPath);
        }
        this.builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).acceptEncoding(new String[]{"UTF-8"}).header("User-Agent", (Object)USER_AGENT).header("Authorization", (Object)this.token);
        return this;
    }

    public HttpRequester header(String name, String value) {
        this.builder.header(name, (Object)value);
        return this;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public Response post(UnaryOperator<JSONCodec.JSONObject> entityBuilder) {
        return this.builder.post(Entity.entity((Object)JSONCodec.encodeObject(entityBuilder), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public Response delete() {
        return this.builder.delete();
    }

    public Response head() {
        return this.builder.head();
    }
}

