/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.listeners;

import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.notification.GroupUserLink;
import org.silverpeas.core.admin.user.notification.GroupUserLinkEvent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.chat.ChatUser;
import org.silverpeas.core.chat.ChatUsersRegistration;
import org.silverpeas.core.notification.system.CDIAfterSuccessfulTransactionResourceEventListener;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Service
public class ChatGroupUserLinkEventListener
extends CDIAfterSuccessfulTransactionResourceEventListener<GroupUserLinkEvent> {
    @Inject
    private ChatUsersRegistration registration;

    public void onCreation(GroupUserLinkEvent event) {
        String userId = ((GroupUserLink)event.getTransition().getAfter()).getUserId();
        User user = User.getById((String)userId);
        this.registration.registerUser(user);
    }

    public void onDeletion(GroupUserLinkEvent event) {
        String userId = ((GroupUserLink)event.getTransition().getBefore()).getUserId();
        ChatUser user = ChatUser.fromUser(User.getById((String)userId));
        if (!user.isChatEnabled()) {
            this.registration.unregisterUser((User)user);
        }
    }
}

