/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Bean
@Singleton
public class ChatSettings {
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.chat.settings.chat");
    private static final String CHAT_CLIENT_PREFIX = "chat.client.";
    private final String xmppBaseUrl;

    public String getSilverpeasChatClientId() {
        return this.settings.getString("chat.client.spid", "jsxc");
    }

    public static ChatSettings get() {
        return (ChatSettings)ServiceProvider.getService(ChatSettings.class, (Annotation[])new Annotation[0]);
    }

    protected ChatSettings() {
        String xmppServerUrl = this.settings.getString("chat.servers.xmpp", "").trim();
        this.xmppBaseUrl = xmppServerUrl.endsWith("/") ? xmppServerUrl.substring(0, xmppServerUrl.length() - 1) : xmppServerUrl;
    }

    public int getMaxCachedMsgThresholdPerRoom() {
        return this.settings.getInteger(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".maxCachedMsgThresholdPerRoom", 200);
    }

    public boolean clearCacheOnLogout() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".clearCacheOnLogout", false);
    }

    public boolean clearMessagesOnReconnection() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".clearMessagesOnReconnection", true);
    }

    public String autoRegisterMucNickname() {
        return this.settings.getString(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".autoRegisterMucNickname", Boolean.FALSE.toString());
    }

    public boolean autoJoinOnInvite() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".autoJoinOnInvite", Boolean.TRUE.booleanValue());
    }

    public boolean isReplyToEnabled() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".replyTo.enabled", true);
    }

    public boolean isReactionToEnabled() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".reactionTo.enabled", true);
    }

    public boolean isVisioEnabled() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".visio.enabled", true);
    }

    public String getVisioUrl() {
        if (this.isVisioEnabled()) {
            String url = this.settings.getString(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".visio.url", "/visio");
            return url.startsWith("http") ? url : URLUtil.getCurrentServerURL() + URLUtil.getApplicationURL() + url;
        }
        return "";
    }

    public String getVisioDomainServer() {
        if (this.isVisioEnabled()) {
            return this.settings.getString(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".visio.domainServer", "meet.jit.si");
        }
        return "";
    }

    public String getVisioJwt() {
        if (this.isVisioEnabled()) {
            return this.settings.getString(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".visio.jwt", "");
        }
        return "";
    }

    public boolean isScreencastEnabled() {
        return this.settings.getBoolean(CHAT_CLIENT_PREFIX + this.getSilverpeasChatClientId() + ".screencast.enabled", true);
    }

    public String getChatServerUrl() {
        return this.xmppBaseUrl;
    }

    public boolean isChatServerSafeUrl() {
        return this.settings.getBoolean("chat.servers.xmpp.safe", false);
    }

    public String getICEServer() {
        return Optional.ofNullable(this.settings.getString("chat.servers.ice", null)).filter(i -> this.isVisioEnabled()).orElse("");
    }

    public String getRestApiUrl() {
        String rest = this.settings.getString("chat.xmpp.rest", "").trim();
        if (!rest.isEmpty()) {
            if (rest.startsWith("/")) {
                return this.xmppBaseUrl + rest;
            }
            return this.xmppBaseUrl + "/" + rest;
        }
        return "";
    }

    public String getBOSHServiceUrl() {
        String bosh = this.settings.getString("chat.xmpp.httpBind", "").trim();
        if (!bosh.isEmpty()) {
            if (bosh.startsWith("/")) {
                return this.xmppBaseUrl + bosh;
            }
            return this.xmppBaseUrl + "/" + bosh;
        }
        return "";
    }

    public String getWebsocketServiceUrl() {
        String ws = this.settings.getString("chat.xmpp.wsBind", "").trim();
        if (!ws.isEmpty()) {
            String xmppBaseWsUrl = this.xmppBaseUrl.replaceFirst("http", "ws");
            if (ws.startsWith("/")) {
                return xmppBaseWsUrl + ws;
            }
            return xmppBaseWsUrl + "/" + ws;
        }
        return "";
    }

    public String getFileTransferServiceUrl() {
        return this.settings.getString("chat.xmpp.httpUpload", this.xmppBaseUrl).trim();
    }

    public String getRestApiAuthToken() {
        return this.settings.getString("chat.xmpp.restKey", "");
    }

    public String getExplicitMappedXmppDomain(String silverpeasDomainId) {
        String xmppDomain = "";
        if (StringUtil.isDefined((String)silverpeasDomainId)) {
            xmppDomain = this.settings.getString("chat.xmpp.domain." + silverpeasDomainId, "").trim();
        }
        return xmppDomain;
    }

    public String getDefaultXmppDomain() {
        return this.settings.getString("chat.xmpp.domain.default", "").trim();
    }

    public String getMappedXmppDomain(String silverpeasDomainId) {
        String xmppDomain = this.getExplicitMappedXmppDomain(silverpeasDomainId).trim();
        if (xmppDomain.isEmpty()) {
            return this.getDefaultXmppDomain();
        }
        return xmppDomain;
    }

    public List<String> getAllowedUserGroups() {
        return this.getListProperty("chat.xmpp.domain.groups");
    }

    public JidFormatPolicy getJidFormatPolicy() {
        JidFormatPolicy[] policies;
        int policy = this.settings.getInteger("chat.xmpp.jid.policy", 1);
        if (policy >= (policies = JidFormatPolicy.values()).length) {
            throw new SilverpeasRuntimeException("Unknown JID format policy value: " + policy);
        }
        return policies[policy];
    }

    public ChatACL getACL() {
        return new ChatACL();
    }

    public boolean isChatEnabled() {
        boolean enabled = this.settings.getBoolean("chat.enable");
        String rest = this.settings.getString("chat.xmpp.rest", "");
        String bosh = this.settings.getString("chat.xmpp.httpBind", "");
        String ws = this.settings.getString("chat.xmpp.wsBind", "");
        return enabled && !rest.isEmpty() && (!bosh.isEmpty() || !ws.isEmpty());
    }

    private List<String> getListProperty(String property) {
        String groups = this.settings.getString(property, "");
        return groups.trim().isEmpty() ? Collections.emptyList() : Stream.of(groups.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static enum JidFormatPolicy {
        REMOVED,
        SPECIFIC_CODE;

    }

    public class ChatACL {
        private ChatACL() {
        }

        public GroupChat getAclOnGroupChat() {
            return new GroupChat();
        }

        public class GroupChat {
            private GroupChat() {
            }

            public List<String> getGroupsAllowedToCreate() {
                return ChatSettings.this.getListProperty("chat.acl.groupchat.creation");
            }
        }
    }
}

