/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.workflow.api.model.Column;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.model.Presentation;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.engine.datarecord.IndexedFieldTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ItemTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ProcessIdTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceRowRecord;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceTemplate;
import org.silverpeas.core.workflow.engine.datarecord.StateTemplate;
import org.silverpeas.core.workflow.engine.datarecord.TitleTemplate;

public class ProcessInstanceRowTemplate
extends ProcessInstanceTemplate {
    private boolean isProcessIdVisible = false;
    private final transient ProcessModel processModel;
    private final String role;
    private final String lang;

    public ProcessInstanceRowTemplate(ProcessModel processModel, String role, String lang) {
        this.processModel = processModel;
        this.role = role;
        this.lang = lang;
        this.init();
    }

    public ProcessInstanceRowTemplate(ProcessModel processModel, String role, String lang, boolean isProcessIdVisible) {
        this.processModel = processModel;
        this.role = role;
        this.lang = lang;
        this.isProcessIdVisible = isProcessIdVisible;
        this.init();
    }

    public FieldTemplate getFieldTemplate(String fieldName) throws FormException {
        IndexedFieldTemplate indexed = (IndexedFieldTemplate)this.fields.get(fieldName);
        if (indexed == null) {
            throw new FormException("Unknown field " + fieldName, new String[0]);
        }
        return indexed.fieldTemplate;
    }

    @Override
    public FieldTemplate getFieldTemplate(int fieldIndex) throws FormException {
        if (0 <= fieldIndex && fieldIndex < this.fields.size()) {
            return this.getFieldTemplates()[fieldIndex];
        }
        throw new FormException("Unknown field at index " + fieldIndex, new String[0]);
    }

    public int getFieldIndex(String fieldName) throws FormException {
        IndexedFieldTemplate indexed = (IndexedFieldTemplate)this.fields.get(fieldName);
        if (indexed == null) {
            throw new FormException("Unknown field " + fieldName, new String[0]);
        }
        return indexed.index;
    }

    public DataRecord getEmptyRecord() throws FormException {
        throw new FormException("Unsupported operation", new String[0]);
    }

    public boolean checkDataRecord(DataRecord record) {
        if (record instanceof ProcessInstanceRowRecord) {
            ProcessInstanceRowRecord rowRecord = (ProcessInstanceRowRecord)record;
            return this == rowRecord.template;
        }
        return false;
    }

    @Override
    public Field[] buildFieldsArray() {
        return new Field[this.fields.size()];
    }

    private void init() {
        if (this.isProcessIdVisible) {
            this.addField(new ProcessIdTemplate("instance.id", this.lang));
        }
        this.addField(new TitleTemplate("title", this.role, this.lang));
        this.addField(new StateTemplate("instance.state", this.processModel, this.role, this.lang));
        Presentation presentation = this.processModel.getPresentation();
        if (presentation != null) {
            Column[] columns = presentation.getColumns(this.role);
            for (int i = 0; columns != null && i < columns.length; ++i) {
                Item item = columns[i].getItem();
                if (item == null) continue;
                this.addField(new ItemTemplate(item.getName(), item, this.role, this.lang));
            }
        }
    }

    private void addField(FieldTemplate fieldTemplate) {
        this.fields.put(fieldTemplate.getFieldName(), new IndexedFieldTemplate(this.fields.size(), fieldTemplate));
    }
}

