/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contact.model;

import java.io.Serializable;
import java.util.Date;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.contact.model.Contact;
import org.silverpeas.core.contact.model.ContactPK;
import org.silverpeas.kernel.util.StringUtil;

public class ContactDetail
implements Contact,
Serializable {
    private static final long serialVersionUID = 2773600943308714640L;
    private ContactPK pk;
    private String firstName;
    private String lastName;
    private String email;
    private String phone;
    private String fax;
    private String userId;
    private Date creationDate;
    private String creatorId;
    private boolean userExtraDataRequired = false;
    private boolean userExtraDataLoaded = false;
    private UserFull userFull;

    public ContactDetail(ContactPK pk, String firstName, String lastName, String email, String phone, String fax, String userId, Date creationDate, String creatorId) {
        this.pk = pk;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phone = phone;
        this.fax = fax;
        this.userId = userId;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
    }

    public ContactDetail(String id, String firstName, String lastName, String email, String phone, String fax, String userId, Date creationDate, String creatorId) {
        this.pk = new ContactPK(id);
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phone = phone;
        this.fax = fax;
        this.userId = userId;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
    }

    public ContactDetail(ContactPK pk) {
        this.pk = pk;
    }

    @Override
    public ContactPK getPK() {
        return this.pk;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPhone() {
        if (StringUtil.isDefined((String)this.phone)) {
            return this.phone;
        }
        if (this.getUserFull() != null) {
            return this.getUserFull().getValue("phone");
        }
        return null;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    public String getFax() {
        if (StringUtil.isDefined((String)this.fax)) {
            return this.fax;
        }
        if (this.getUserFull() != null) {
            return this.getUserFull().getValue("fax");
        }
        return null;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setUserExtraDataRequired(boolean userExtraDataRequired) {
        this.userExtraDataRequired = userExtraDataRequired;
    }

    @Override
    public UserFull getUserFull() {
        if (this.userExtraDataRequired && !this.userExtraDataLoaded && this.getUserId() != null && this.userFull == null) {
            this.userFull = OrganizationController.get().getUserFull(this.getUserId());
            this.userExtraDataLoaded = true;
        }
        return this.userFull;
    }

    public String toString() {
        Object result = "ContactDetail {\n";
        result = (String)result + "  getPK() = " + this.getPK().toString() + "\n";
        result = (String)result + "  getFirstName() = " + this.getFirstName() + "\n";
        result = (String)result + "  getLastName() = " + this.getLastName() + "\n";
        result = (String)result + "  getEmail() = " + this.getEmail() + "\n";
        result = (String)result + "  getPhone() = " + this.getPhone() + "\n";
        result = (String)result + "  getFax() = " + this.getFax() + "\n";
        result = (String)result + "  getUserId() = " + this.getUserId() + "\n";
        result = (String)result + "  getCreationDate() = " + this.getCreationDate() + "\n";
        result = (String)result + "  getCreatorId() = " + this.getCreatorId() + "\n";
        result = (String)result + "  getUserFull() = " + this.getUserFull() + "\n";
        result = (String)result + "}";
        return result;
    }
}

