/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.pdc.classification.ClassifyEngine;
import org.silverpeas.core.pdc.pdc.model.AxisHeader;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderPersistence;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.model.UsedAxisPK;
import org.silverpeas.core.pdc.pdc.service.PdcUtilizationDAO;
import org.silverpeas.core.pdc.pdc.service.PdcUtilizationService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DefaultPdcUtilizationService
implements PdcUtilizationService,
ComponentInstanceDeletion {
    private static final String AXIS_ID = "axisId";
    @Inject
    private ClassifyEngine classifyEngine;
    private SilverpeasBeanDAO<UsedAxis> dao = null;
    @Inject
    private PdcUtilizationDAO utilizationDAO;

    protected DefaultPdcUtilizationService() {
        try {
            this.dao = SilverpeasBeanDAOFactory.getDAO(UsedAxis.class);
        }
        catch (PersistenceException e) {
            SilverLogger.getLogger((Object)this).error("Failed to get the DAO for UsedAxis", (Throwable)e);
        }
    }

    @Override
    public UsedAxis getUsedAxis(String usedAxisId) throws PdcException {
        UsedAxis usedAxis;
        try {
            usedAxis = (UsedAxis)this.dao.findByPrimaryKey((WAPrimaryKey)new UsedAxisPK(usedAxisId));
        }
        catch (PersistenceException e) {
            throw new PdcException(e);
        }
        return usedAxis;
    }

    @Override
    public List<UsedAxis> getUsedAxisByInstanceId(String instanceId) throws PdcException {
        List<UsedAxis> usedAxis;
        try (Connection con = DBUtil.openConnection();){
            usedAxis = this.utilizationDAO.getUsedAxisByInstanceId(con, instanceId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        return usedAxis;
    }

    @Override
    public List<AxisHeader> getAxisHeaderUsedByInstanceIds(List<String> instanceIds) throws PdcException {
        ArrayList<AxisHeader> arrayList;
        block11: {
            if (instanceIds == null || instanceIds.isEmpty()) {
                return new ArrayList<AxisHeader>(0);
            }
            Connection con = DBUtil.openConnection();
            try {
                List<Integer> ids = this.classifyEngine.getPertinentAxisByInstanceIds(instanceIds);
                SilverpeasBeanDAO theDao = SilverpeasBeanDAOFactory.getDAO(AxisHeaderPersistence.class);
                BeanCriteria criteria = BeanCriteria.addCriterion((String)"id", ids);
                Collection result = theDao.findBy(con, criteria);
                ArrayList<AxisHeader> axisHeaders = new ArrayList<AxisHeader>();
                if (result != null) {
                    for (AxisHeaderPersistence silverpeasBean : result) {
                        AxisHeader axisHeader = new AxisHeader(silverpeasBean);
                        axisHeaders.add(axisHeader);
                    }
                }
                arrayList = axisHeaders;
                if (con == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PdcException(e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    private List<UsedAxis> getUsedAxisByAxisId(@NonNull Connection con, int axisId) throws PdcException {
        try {
            Objects.requireNonNull(con);
            return (List)this.dao.findBy(con, BeanCriteria.addCriterion((String)AXIS_ID, (Object)axisId));
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addUsedAxis(UsedAxis usedAxis, String treeId) throws PdcException {
        try (Connection con = DBUtil.openConnection();){
            if (this.utilizationDAO.isAlreadyAdded(con, usedAxis.getInstanceId(), Integer.parseInt(usedAxis.getPK().getId()), usedAxis.getAxisId(), usedAxis.getBaseValue(), treeId)) {
                int n = 1;
                return n;
            }
            this.dao.add((SilverpeasEntityBean)usedAxis);
            return 0;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateUsedAxis(UsedAxis usedAxis, String treeId) throws PdcException {
        try (Connection con = DBUtil.openConnection();){
            int newBaseValue = usedAxis.getBaseValue();
            int oldBaseValue = this.getUsedAxis(usedAxis.getPK().getId()).getBaseValue();
            if (newBaseValue != oldBaseValue && this.utilizationDAO.isAlreadyAdded(con, usedAxis.getInstanceId(), Integer.parseInt(usedAxis.getPK().getId()), usedAxis.getAxisId(), usedAxis.getBaseValue(), treeId)) {
                int n2 = 1;
                return n2;
            }
            this.dao.update((SilverpeasEntityBean)usedAxis);
            this.utilizationDAO.updateAllUsedAxis(con, usedAxis);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public void deleteUsedAxis(String usedAxisId) throws PdcException {
        try {
            this.dao.remove((WAPrimaryKey)new UsedAxisPK(usedAxisId));
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public void deleteUsedAxisByAxisId(Connection con, String axisId) throws PdcException {
        try {
            Objects.requireNonNull(con);
            BeanCriteria criteria = BeanCriteria.addCriterion((String)AXIS_ID, (Object)Integer.parseInt(axisId));
            this.dao.removeBy(con, criteria);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    private void deleteUsedAxisByValueId(@NonNull Connection con, int valueId, int axisId) throws PdcException {
        try {
            Objects.requireNonNull(con);
            BeanCriteria criteria = BeanCriteria.addCriterion((String)AXIS_ID, (Object)axisId).and("baseValue", (Object)valueId);
            this.dao.removeBy(con, criteria);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public void deleteUsedAxisByMotherValue(Connection con, String valueId, String axisId, String treeId) throws PdcException {
        try {
            BeanCriteria queryCriteria = BeanCriteria.addCriterion((String)"treeId", (Object)Integer.parseInt(treeId)).and(BeanCriteria.addCriterion((String)"path", (BeanCriteria.OPERATOR)BeanCriteria.OPERATOR.LIKE, (Object)("%/" + valueId + "/%")).or("id", (Object)Integer.parseInt(valueId)));
            BeanCriteria criteria = BeanCriteria.addCriterion((String)AXIS_ID, (Object)Integer.parseInt(axisId)).andSubQuery("baseValue", BeanCriteria.OPERATOR.IN, "id from SB_Tree_Tree", queryCriteria);
            this.dao.removeBy(con, criteria);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    private void updateBaseValue(Connection con, int oldBaseValue, int newBaseValue, int axisId, String treeId, String instanceId) throws PdcException {
        try {
            this.utilizationDAO.updateBaseValue(con, oldBaseValue, newBaseValue, axisId, treeId, instanceId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public void updateOrDeleteBaseValue(Connection con, int baseValueToUpdate, int newBaseValue, int axisId, String treeId) throws PdcException {
        Objects.requireNonNull(con);
        List<UsedAxis> usedAxisList = this.getUsedAxisByAxisId(con, axisId);
        for (UsedAxis anUsedAxisList : usedAxisList) {
            boolean updateAllowed;
            String instanceId = anUsedAxisList.getInstanceId();
            if (anUsedAxisList.getBaseValue() != baseValueToUpdate) continue;
            try {
                updateAllowed = !this.utilizationDAO.isAlreadyAdded(con, instanceId, Integer.parseInt(anUsedAxisList.getPK().getId()), axisId, newBaseValue, treeId);
            }
            catch (Exception e) {
                throw new PdcException(e);
            }
            if (!updateAllowed) continue;
            this.updateBaseValue(con, baseValueToUpdate, newBaseValue, axisId, treeId, instanceId);
        }
        this.deleteUsedAxisByValueId(con, baseValueToUpdate, axisId);
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            this.utilizationDAO.deleteAllAxisUsedByInstanceId(connection, componentInstanceId);
        }
        catch (SQLException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

