/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.tar.LocalJournalFile;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.tool.check.CheckHelper;

public class Check {
    private final File path;
    private final boolean mmap;
    private final File journal;
    private final long debugInterval;
    private final boolean checkBinaries;
    private final boolean checkHead;
    private final Integer revisionsCount;
    private final Set<String> requestedCheckpoints;
    private final Set<String> filterPaths;
    private final boolean ioStatistics;
    private RepositoryStatistics repoStatistics;
    private final PrintWriter out;
    private final PrintWriter err;
    private final boolean failFast;

    public static Builder builder() {
        return new Builder();
    }

    private Check(Builder builder) {
        this.path = builder.path;
        this.mmap = builder.mmap;
        this.debugInterval = builder.debugInterval;
        this.checkHead = builder.checkHead;
        this.checkBinaries = builder.checkBinaries;
        this.requestedCheckpoints = builder.checkpoints;
        this.filterPaths = builder.filterPaths;
        this.ioStatistics = builder.ioStatistics;
        this.repoStatistics = builder.repoStatistics;
        this.out = builder.outWriter;
        this.err = builder.errWriter;
        this.journal = Check.journalPath(builder.path, builder.journal);
        this.revisionsCount = Check.revisionsToCheckCount(builder.revisionsCount);
        this.failFast = builder.failFast;
    }

    private static File journalPath(File segmentStore, File journal) {
        if (journal == null) {
            return new File(segmentStore, "journal.log");
        }
        return journal;
    }

    private static Integer revisionsToCheckCount(Integer revisionsCount) {
        return revisionsCount != null ? revisionsCount : Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int run() {
        StatisticsIOMonitor ioMonitor = new StatisticsIOMonitor();
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(this.path).withMemoryMapping(this.mmap).withCustomPersistence(new TarPersistence(this.path, this.journal));
        if (this.ioStatistics) {
            builder.withIOMonitor(ioMonitor);
        }
        CheckHelper checkHelper = CheckHelper.builder().withCheckBinaries(this.checkBinaries).withCheckpoints(this.requestedCheckpoints).withCheckHead(this.checkHead).withDebugInterval(this.debugInterval).withFailFast(this.failFast).withFilterPaths(this.filterPaths).withRevisionsCount(this.revisionsCount).withErrWriter(this.err).withOutWriter(this.out).build();
        try (ReadOnlyFileStore store = builder.buildReadOnly();){
            int n;
            try (JournalReader journal = new JournalReader(new LocalJournalFile(this.journal));){
                int result = checkHelper.run(store, journal);
                if (this.ioStatistics) {
                    this.print("[I/O] Segment read: Number of operations: {0}", ioMonitor.ops.get());
                    this.print("[I/O] Segment read: Total size: {0} ({1} bytes)", IOUtils.humanReadableByteCount((long)ioMonitor.bytes.get()), ioMonitor.bytes.get());
                    this.print("[I/O] Segment read: Total time: {0} ns", ioMonitor.time.get());
                }
                if (this.repoStatistics != null) {
                    this.repoStatistics.headNodeCount = checkHelper.getHeadNodeCount();
                    this.repoStatistics.headPropertyCount = checkHelper.getHeadPropertyCount();
                }
                n = result;
            }
            return n;
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            return 1;
        }
    }

    private void print(String format, Object ... arguments) {
        this.out.println(MessageFormat.format(format, arguments));
    }

    public static class RepositoryStatistics {
        int headNodeCount;
        int headPropertyCount;

        public void setHeadPropertyCount(int headPropertyCount) {
            this.headPropertyCount = headPropertyCount;
        }

        public void setHeadNodeCount(int headNodeCount) {
            this.headNodeCount = headNodeCount;
        }

        public int getHeadNodeCount() {
            return this.headNodeCount;
        }

        public int getHeadPropertyCount() {
            return this.headPropertyCount;
        }
    }

    private static class StatisticsIOMonitor
    extends IOMonitorAdapter {
        AtomicLong ops = new AtomicLong(0L);
        AtomicLong bytes = new AtomicLong(0L);
        AtomicLong time = new AtomicLong(0L);

        private StatisticsIOMonitor() {
        }

        @Override
        public void afterSegmentRead(File file, long msb, long lsb, int length, long elapsed) {
            this.ops.incrementAndGet();
            this.bytes.addAndGet(length);
            this.time.addAndGet(elapsed);
        }
    }

    public static class Builder {
        private File path;
        private boolean mmap;
        private File journal;
        private long debugInterval = Long.MAX_VALUE;
        private boolean checkBinaries;
        private boolean checkHead;
        private Integer revisionsCount;
        private Set<String> checkpoints;
        private Set<String> filterPaths;
        private boolean ioStatistics;
        private RepositoryStatistics repoStatistics;
        private PrintWriter outWriter;
        private PrintWriter errWriter;
        private boolean failFast;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder withMmap(boolean mmap) {
            this.mmap = mmap;
            return this;
        }

        public Builder withJournal(File journal) {
            this.journal = Objects.requireNonNull(journal);
            return this;
        }

        public Builder withDebugInterval(long debugInterval) {
            Validate.checkArgument((debugInterval >= 0L ? 1 : 0) != 0);
            this.debugInterval = debugInterval;
            return this;
        }

        public Builder withCheckBinaries(boolean checkBinaries) {
            this.checkBinaries = checkBinaries;
            return this;
        }

        public Builder withCheckHead(boolean checkHead) {
            this.checkHead = checkHead;
            return this;
        }

        public Builder withRevisionsCount(Integer revisionsCount) {
            this.revisionsCount = revisionsCount;
            return this;
        }

        public Builder withCheckpoints(Set<String> checkpoints) {
            this.checkpoints = checkpoints;
            return this;
        }

        public Builder withFilterPaths(Set<String> filterPaths) {
            this.filterPaths = filterPaths;
            return this;
        }

        public Builder withIOStatistics(boolean ioStatistics) {
            this.ioStatistics = ioStatistics;
            return this;
        }

        public Builder withRepositoryStatistics(RepositoryStatistics repoStatistics) {
            this.repoStatistics = repoStatistics;
            return this;
        }

        public Builder withOutWriter(PrintWriter outWriter) {
            this.outWriter = outWriter;
            return this;
        }

        public Builder withErrWriter(PrintWriter errWriter) {
            this.errWriter = errWriter;
            return this;
        }

        public Builder withFailFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Check build() {
            Objects.requireNonNull(this.path);
            return new Check(this);
        }
    }
}

