/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.HexDump;
import org.apache.jackrabbit.oak.commons.Buffer;

class SegmentDataUtils {
    private SegmentDataUtils() {
    }

    static void hexDump(Buffer buffer, OutputStream stream) throws IOException {
        byte[] data = new byte[buffer.remaining()];
        buffer.duplicate().get(data);
        HexDump.dump((byte[])data, (long)0L, (OutputStream)stream, (int)0);
    }

    static void binDump(Buffer buffer, OutputStream stream) throws IOException {
        Buffer data = buffer.duplicate();
        try (WritableByteChannel channel = Channels.newChannel(stream);){
            while (data.hasRemaining()) {
                data.write(channel);
            }
        }
    }

    static int estimateMemoryUsage(Buffer buffer) {
        return buffer.isDirect() ? 0 : buffer.remaining();
    }

    static Buffer readBytes(Buffer buffer, int index, int size) {
        Buffer duplicate = buffer.duplicate();
        duplicate.position(index);
        duplicate.limit(index + size);
        return duplicate.slice();
    }

    static int index(Buffer buffer, int recordReferenceOffset) {
        return buffer.limit() - (262144 - recordReferenceOffset);
    }
}

