/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.DebugParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DebugEventData
implements EventResponseData {
    private int dsTime;
    private int milliSeconds;
    private String perpetratorDN;
    private String formatString;
    private int verb;
    private int parametercount;
    private List parameters = Collections.EMPTY_LIST;

    public DebugEventData(ASN1Object message) throws IOException {
        byte[] bytedata = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(bytedata);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.dsTime = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.milliSeconds = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.perpetratorDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.formatString = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.verb = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.parametercount = ((ASN1Integer)decode.decode(in, length)).intValue();
        if (this.parametercount > 0) {
            this.parameters = new ArrayList();
            ASN1Sequence seq = (ASN1Sequence)decode.decode(in, length);
            for (int i = 0; i < this.parametercount; ++i) {
                this.parameters.add(new DebugParameter((ASN1Tagged)seq.get(i)));
            }
        }
    }

    public int getMilliSeconds() {
        return this.milliSeconds;
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getPerpetratorDN() {
        return this.perpetratorDN;
    }

    public int getVerb() {
        return this.verb;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DebugEventData");
        buf.append("(Millseconds=" + this.getMilliSeconds() + ")");
        buf.append("(DSTime =" + this.getDsTime() + ")");
        buf.append("(PerpetratorDN=" + this.getPerpetratorDN() + ")");
        buf.append("(Verb=" + this.getVerb() + ")");
        buf.append("(Parameters=" + this.getParameters() + ")");
        buf.append("]");
        return buf.toString();
    }

    public int getDsTime() {
        return this.dsTime;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

