/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcSearchResultEntry;
import java.io.IOException;
import java.util.Iterator;

public class LDAPSearchResult
extends LDAPMessage {
    private LDAPEntry entry = null;

    public LDAPSearchResult() {
    }

    LDAPSearchResult(RfcLDAPMessage message) {
        super(message);
    }

    public LDAPSearchResult(LDAPEntry entry, LDAPControl[] cont) {
        super(new RfcLDAPMessage(new RfcSearchResultEntry(new ASN1OctetString(entry.getDN()), LDAPSearchResult.getEntrySequence(entry)), LDAPSearchResult.RfcControlFactory(cont)));
        this.entry = entry;
    }

    private static RfcControls RfcControlFactory(LDAPControl[] controls) {
        RfcControls rfcs = new RfcControls();
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                rfcs.add(controls[i].getASN1Object());
            }
            return rfcs;
        }
        return null;
    }

    private static ASN1Sequence getEntrySequence(LDAPEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Argument \"entry\" cannot be null");
        }
        Iterator entryiterator = entry.getAttributeSet().iterator();
        ASN1Sequence attributelistsequence = new ASN1Sequence();
        while (entryiterator.hasNext()) {
            ASN1Sequence attributesequence = new ASN1Sequence();
            LDAPAttribute attribute = (LDAPAttribute)entryiterator.next();
            attributesequence.add(new ASN1OctetString(attribute.getName()));
            ASN1Set valueset = new ASN1Set();
            String[] valueArray = attribute.getStringValueArray();
            if (valueArray != null) {
                for (int i = 0; i < valueArray.length; ++i) {
                    valueset.add(new ASN1OctetString(valueArray[i]));
                }
            }
            attributesequence.add(valueset);
            attributelistsequence.add(attributesequence);
        }
        return attributelistsequence;
    }

    public LDAPEntry getEntry() {
        if (this.entry == null) {
            LDAPAttributeSet attrs = new LDAPAttributeSet();
            ASN1Sequence attrList = ((RfcSearchResultEntry)this.message.getResponse()).getAttributes();
            ASN1Object[] seqArray = attrList.toArray();
            for (int i = 0; i < seqArray.length; ++i) {
                ASN1Sequence seq = (ASN1Sequence)seqArray[i];
                LDAPAttribute attr = new LDAPAttribute(((ASN1OctetString)seq.get(0)).stringValue());
                ASN1Set set = (ASN1Set)seq.get(1);
                ASN1Object[] setArray = set.toArray();
                for (int j = 0; j < setArray.length; ++j) {
                    attr.addValue(((ASN1OctetString)setArray[j]).byteValue());
                }
                attrs.add(attr);
            }
            this.entry = new LDAPEntry(((RfcSearchResultEntry)this.message.getResponse()).getObjectName().stringValue(), attrs);
        }
        return this.entry;
    }

    public String toString() {
        String str = this.entry == null ? super.toString() : this.entry.toString();
        return str;
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPSearchResult)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPSearchResult object");
        }
        LDAPSearchResult tmp = (LDAPSearchResult)readObject;
        LDAPEntry entry = tmp.getEntry();
        tmp = null;
        this.message = new RfcLDAPMessage(new RfcSearchResultEntry(new ASN1OctetString(entry.getDN()), LDAPSearchResult.getEntrySequence(entry)), asn1Ctrls);
        readObject = null;
    }
}

