/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.BackgroundReadStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandler;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.observation.ChangeSetBuilder;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ExternalChange {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalChange.class);
    private final DocumentNodeStore store;
    protected final BackgroundReadStats stats;
    private ChangeSetBuilder changeSetBuilder;
    private final JournalPropertyHandler journalPropertyHandler;

    ExternalChange(DocumentNodeStore store) {
        this.store = store;
        this.stats = new BackgroundReadStats();
        this.journalPropertyHandler = store.getJournalPropertyHandlerFactory().newHandler();
    }

    abstract void invalidateCache(@NotNull Iterable<String> var1);

    abstract void invalidateCache();

    abstract void updateHead(@NotNull Set<Revision> var1, @NotNull RevisionVector var2, @Nullable Iterable<String> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundReadStats process() {
        Clock clock = this.store.getClock();
        int clusterId = this.store.getClusterId();
        long time = clock.getTime();
        String id = Utils.getIdFromPath(Path.ROOT);
        NodeDocument doc = this.store.getDocumentStore().find(Collection.NODES, id, this.store.getAsyncDelay());
        if (doc == null) {
            return this.stats;
        }
        try {
            Utils.alignWithExternalRevisions(doc, clock, clusterId, this.store.getMaxTimeDiffMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Background read interrupted", e);
        }
        StringSort externalSort = JournalEntry.newSorter();
        StringSort invalidate = JournalEntry.newSorter();
        AtomicLong oldestTimestamp = new AtomicLong(Long.MAX_VALUE);
        Consumer<JournalEntry> journalEntryConsumer = journalEntry -> oldestTimestamp.set(Math.min(oldestTimestamp.get(), journalEntry.getRevisionTimestamp()));
        Map<Integer, Revision> lastRevMap = doc.getLastRev();
        try {
            this.changeSetBuilder = new ChangeSetBuilder(this.store.getChangeSetMaxItems(), this.store.getChangeSetMaxDepth());
            RevisionVector headRevision = this.store.getHeadRevision();
            HashSet<Revision> externalChanges = new HashSet<Revision>();
            for (Map.Entry<Integer, Revision> e : lastRevMap.entrySet()) {
                int machineId = e.getKey();
                if (machineId == clusterId) continue;
                Revision r = e.getValue();
                Revision last = headRevision.getRevision(machineId);
                if (last == null) {
                    last = new Revision(0L, 0, machineId);
                }
                if (r.compareRevisionTime(last) <= 0) continue;
                externalChanges.add(r);
                if (externalSort == null) continue;
                try {
                    JournalEntry.fillExternalChanges(externalSort, invalidate, Path.ROOT, last, r, this.store.getDocumentStore(), journalEntryConsumer, this.changeSetBuilder, this.journalPropertyHandler);
                }
                catch (Exception e1) {
                    LOG.error("backgroundRead: Exception while reading external changes from journal: " + e1, (Throwable)e1);
                    IOUtils.closeQuietly((Closeable)externalSort);
                    IOUtils.closeQuietly((Closeable)invalidate);
                    externalSort = null;
                    invalidate = null;
                }
            }
            this.stats.readHead = clock.getTime() - time;
            time = clock.getTime();
            if (this.cacheInvalidationNeeded(externalSort, invalidate)) {
                if (externalSort == null) {
                    this.invalidateCache();
                } else {
                    this.stats.numExternalChanges = externalSort.getSize();
                    try {
                        this.sortAndInvalidate(externalSort);
                        this.sortAndInvalidate(invalidate);
                    }
                    catch (Exception ioe) {
                        LOG.error("backgroundRead: got IOException during external sorting/cache invalidation (as a result, invalidating entire cache): " + ioe, (Throwable)ioe);
                        this.invalidateCache();
                    }
                }
                this.stats.cacheInvalidationTime = clock.getTime() - time;
            }
            if (!externalChanges.isEmpty()) {
                this.updateHead(externalChanges, doc.getSweepRevisions(), (Iterable<String>)externalSort);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)externalSort);
            IOUtils.closeQuietly((Closeable)invalidate);
        }
        if (oldestTimestamp.get() != Long.MAX_VALUE) {
            this.stats.externalChangesLag = clock.getTime() - oldestTimestamp.get();
        }
        return this.stats;
    }

    ChangeSetBuilder getChangeSetBuilder() {
        return this.changeSetBuilder;
    }

    JournalPropertyHandler getJournalPropertyHandler() {
        return this.journalPropertyHandler;
    }

    private boolean cacheInvalidationNeeded(StringSort externalSort, StringSort invalidate) {
        return externalSort == null || invalidate == null || !externalSort.isEmpty() || !invalidate.isEmpty();
    }

    private void sortAndInvalidate(StringSort paths) throws IOException {
        if (paths.isEmpty()) {
            return;
        }
        paths.sort();
        this.invalidateCache((Iterable<String>)paths);
    }
}

