/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.Cipher;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Asymmetric {
    private static int BUFFERSIZE_TEXT = 64;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer encrypt(StringBuffer text, PublicKey encryptKey) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Asymmetric.encrypt(new ByteArrayInputStream(text.toString().getBytes()), dao, encryptKey, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var6_6 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    public static void encrypt(InputStream is, DataOutputStream daos, PublicKey encryptKey, int bufferlength) throws CryptoException, IOException {
        Cipher cipher = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            cipher = Cipher.getInstance("RSA/ECB/OAEPPadding", "BC");
            cipher.init(1, encryptKey);
            byte[] buffer = new byte[bufferlength];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                cipher.update(buffer, 0, length);
            }
            byte[] result = cipher.doFinal();
            daos.write(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer decrypt(StringBuffer text, PrivateKey decryptKey) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Asymmetric.decrypt(new ByteArrayInputStream(Base64.decode((String)text.toString())), dao, decryptKey, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(bao.toByteArray()));
                Object var6_6 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    public static void decrypt(InputStream is, DataOutputStream daos, PrivateKey decryptKey, int bufferlength) throws CryptoException, IOException {
        Cipher cipher = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            cipher = Cipher.getInstance("RSA/ECB/OAEPPadding", "BC");
            cipher.init(2, decryptKey);
            byte[] buffer = new byte[bufferlength];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                cipher.update(buffer, 0, length);
            }
            byte[] result = cipher.doFinal();
            daos.write(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }
}

