/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class DateUtil {
    public static final java.util.Date MINIMUM_DATE = new java.util.Date(Date.valueOf("1900-01-01").getTime());
    public static final java.util.Date MAXIMUM_DATE = new java.util.Date(Date.valueOf("2999-12-31").getTime());
    private static final DateUtil instance = new DateUtil();
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final String HOUR_OUTPUT_FORMAT = "hourOutputFormat";
    private static final String DATE_INPUT_FORMAT = "dateInputFormat";
    private static Map<String, FastDateFormat> outputFormatters = new HashMap<String, FastDateFormat>(5);
    private static Map<String, SimpleDateFormat> inputParsers = new HashMap<String, SimpleDateFormat>(5);
    private static final String DEFAULT_DAY_PATTERN = "yyyy/MM/dd";
    private final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy/MM/dd");
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy/MM/dd");
    private static final SimpleDateFormat DATETIME_PARSER = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final FastDateFormat ISO8601DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm");
    private static final FastDateFormat ISO8601DAY_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final FastDateFormat ICALDAY_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMdd");
    private static final FastDateFormat ICALDATE_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss");
    private static final FastDateFormat ICALUTCDATE_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
    private static final DateTimeFormatter CUSTOM_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    public static final DateTimeFormatter LUCENE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public final SimpleDateFormat timeParser;
    public static final FastDateFormat TIME_FORMATTER = FastDateFormat.getInstance((String)"HH:mm");

    private DateUtil() {
        this.dateParser.setLenient(false);
        this.timeParser = new SimpleDateFormat("HH:mm");
        this.timeParser.setLenient(false);
    }

    public static String dateToString(java.util.Date date, String language) {
        if (DateUtil.isNotDefined(date)) {
            return "";
        }
        FastDateFormat format = DateUtil.getDateOutputFormat(language);
        return format.format(date);
    }

    public static String getOutputDate(java.util.Date date, String language) {
        if (DateUtil.isNotDefined(date) || DateUtil.isInfinite(date)) {
            return "";
        }
        FastDateFormat formatter = DateUtil.getOutputFormatter(language);
        return formatter.format(date);
    }

    private static boolean isInfinite(java.util.Date date) {
        return date.getTime() == Long.MIN_VALUE || date.getTime() == Long.MAX_VALUE;
    }

    public static String getOutputDate(String dateDB, String language) throws ParseException {
        if (!StringUtil.isDefined((String)dateDB)) {
            return "";
        }
        java.util.Date date = DateUtil.parse(dateDB);
        return DateUtil.getOutputDate(date, language);
    }

    public static String getOutputHour(java.util.Date date, String language) {
        if (DateUtil.isNotDefined(date)) {
            return "";
        }
        FastDateFormat formatter = DateUtil.getHourOutputFormat(language);
        return formatter.format(date);
    }

    public static String getOutputHour(String dateDB, String language) throws ParseException {
        if (!StringUtil.isDefined((String)dateDB)) {
            return "";
        }
        java.util.Date date = DateUtil.parse(dateDB);
        return DateUtil.getOutputHour(date, language);
    }

    public static String getOutputDateAndHour(String dateDB, String language) throws ParseException {
        if (!StringUtil.isDefined((String)dateDB)) {
            return "";
        }
        java.util.Date date = DateUtil.parseDateTime(dateDB);
        return DateUtil.getOutputDateAndHour(date, language);
    }

    public static String getOutputDateAndHour(java.util.Date date, String language) {
        if (DateUtil.isNotDefined(date)) {
            return "";
        }
        if (DateUtils.getFragmentInMilliseconds((java.util.Date)date, (int)5) == 0L) {
            return DateUtil.getOutputDate(date, language);
        }
        FastDateFormat formatter = FastDateFormat.getInstance((String)(DateUtil.getLocalizedProperties(language).getString("dateOutputFormat") + " " + DateUtil.getLocalizedProperties(language).getString(HOUR_OUTPUT_FORMAT)));
        return formatter.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInputDate(java.util.Date date, String language) {
        SimpleDateFormat parser;
        if (DateUtil.isNotDefined(date)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = parser = DateUtil.getInputFormatter(language);
        synchronized (simpleDateFormat) {
            return parser.format(date);
        }
    }

    public static String getInputDate(LocalDate date, String language) {
        if (date == null) {
            return "";
        }
        return date.format(DateUtil.getLocalDateInputFormat(language));
    }

    private static boolean isNotDefined(java.util.Date date) {
        return date == null || new org.silverpeas.core.date.Date(date).isNotDefined();
    }

    public static String getInputDate(String dateDB, String language) throws ParseException {
        if (!StringUtil.isDefined((String)dateDB)) {
            return "";
        }
        java.util.Date date = DateUtil.parse(dateDB);
        return DateUtil.getInputDate(date, language);
    }

    public static java.util.Date stringToDate(String string, String language) throws ParseException {
        SimpleDateFormat format = DateUtil.getDateInputFormat(language);
        try {
            return format.parse(string);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public static LocalDate stringToLocalDate(String string, String language) {
        DateTimeFormatter format = DateUtil.getLocalDateInputFormat(language);
        return LocalDate.parse(string, format);
    }

    public static java.util.Date stringToDate(String date, String hour, String language) throws ParseException {
        try {
            if (hour == null || "".equals(hour.trim())) {
                SimpleDateFormat format = DateUtil.getDateInputFormat(language);
                return format.parse(date);
            }
            SimpleDateFormat format = DateUtil.getDateAndHourInputFormat(language);
            return format.parse(date + " " + hour);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public static java.util.Date getNow() {
        return Calendar.getInstance().getTime();
    }

    public static java.util.Date getDate() {
        return DateUtil.resetHour(DateUtil.getNow());
    }

    public static java.util.Date getDate(java.util.Date date, String hour) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, DateUtil.extractHour(hour));
        calendar.set(12, DateUtil.extractMinutes(hour));
        return calendar.getTime();
    }

    public static int extractHour(String hour) {
        if (!StringUtil.isDefined((String)hour)) {
            return 0;
        }
        if (hour.indexOf(58) != -1) {
            return Integer.parseInt(hour.substring(0, hour.indexOf(58)));
        }
        if (hour.indexOf(104) != -1) {
            return Integer.parseInt(hour.substring(0, hour.indexOf(104)));
        }
        return 0;
    }

    public static int extractMinutes(String hour) {
        if (!StringUtil.isDefined((String)hour)) {
            return 0;
        }
        if (hour.indexOf(58) != -1) {
            return Integer.parseInt(hour.substring(hour.indexOf(58) + 1));
        }
        if (hour.indexOf(104) != -1) {
            return Integer.parseInt(hour.substring(hour.indexOf(104) + 1));
        }
        return 0;
    }

    public static FastDateFormat getDateOutputFormat(String lang) {
        return FastDateFormat.getInstance((String)DateUtil.getLocalizedProperties(lang).getString("dateOutputFormat"));
    }

    public static SimpleDateFormat getDateInputFormat(String language) {
        return new SimpleDateFormat(DateUtil.getLocalizedProperties(language).getString(DATE_INPUT_FORMAT));
    }

    public static DateTimeFormatter getLocalDateInputFormat(String language) {
        return DateTimeFormatter.ofPattern(DateUtil.getLocalizedProperties(language).getString(DATE_INPUT_FORMAT));
    }

    public static FastDateFormat getHourOutputFormat(String lang) {
        return FastDateFormat.getInstance((String)DateUtil.getLocalizedProperties(lang).getString(HOUR_OUTPUT_FORMAT));
    }

    public static SimpleDateFormat getHourInputFormat(String language) {
        return new SimpleDateFormat(DateUtil.getLocalizedProperties(language).getString("hourInputFormat"));
    }

    public static SimpleDateFormat getDateAndHourInputFormat(String lang) {
        return new SimpleDateFormat(DateUtil.getLocalizedProperties(lang).getString(DATE_INPUT_FORMAT) + " " + DateUtil.getLocalizedProperties(lang).getString(HOUR_OUTPUT_FORMAT));
    }

    public static LocalizationBundle getLocalizedProperties(String locale) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.date.multilang.date", (String)locale);
    }

    public static java.util.Date parse(String date) throws ParseException {
        return DateUtil.getDateUtil().parseWithDateParser(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.Date parseWithDateParser(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateParser;
        synchronized (simpleDateFormat) {
            return this.dateParser.parse(date);
        }
    }

    private static DateUtil getDateUtil() {
        return instance;
    }

    public static LocalDate toLocalDate(String date) {
        return LocalDate.parse(date, CUSTOM_FORMATTER);
    }

    public static java.util.Date parse(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(date);
    }

    public static boolean datesAreEqual(java.util.Date date1, java.util.Date date2) {
        return DateUtil.compareTo(date1, date2) == 0;
    }

    public static int compareTo(java.util.Date date1, java.util.Date date2) {
        return DateUtil.compareTo(date1, date2, true);
    }

    public static int compareTo(java.util.Date date1, java.util.Date date2, boolean aForceResetHour) {
        Calendar myCal1 = DateUtil.convert(date1);
        if (aForceResetHour) {
            DateUtil.resetHour(myCal1);
        }
        Calendar myCal2 = DateUtil.convert(date2);
        if (aForceResetHour) {
            DateUtil.resetHour(myCal2);
        }
        return myCal1.getTime().compareTo(myCal2.getTime());
    }

    public static String today2SQLDate() {
        return DateUtil.date2SQLDate(new java.util.Date());
    }

    public static String date2SQLDate(java.util.Date date) {
        return DateUtil.formatDate(date);
    }

    public static String temporal2SQLDate(Temporal temporal) {
        return DateUtil.formatDate(TemporalConverter.asDate(temporal));
    }

    public static String date2SQLDate(String date, String language) throws ParseException {
        String result = null;
        java.util.Date oDate = null;
        if (StringUtil.isDefined((String)date)) {
            oDate = DateUtil.stringToDate(date, language);
        }
        if (oDate != null) {
            result = DateUtil.date2SQLDate(oDate);
        }
        return result;
    }

    public static String firstDayOfMonth2SQLDate(java.util.Date date) {
        Object sqlDate = DATE_FORMATTER.format(date);
        sqlDate = ((String)sqlDate).substring(0, ((String)sqlDate).length() - 2) + "01";
        return sqlDate;
    }

    public static String formatDuration(long duration) {
        long hourDuration = duration / 3600000L;
        long minuteDuration = duration % 3600000L / 60000L;
        long secondDuration = duration % 3600000L % 60000L / 1000L;
        StringBuilder result = new StringBuilder(10);
        if (hourDuration > 0L) {
            if (hourDuration < 10L) {
                result.append('0');
            }
            result.append(hourDuration).append('h');
            if (minuteDuration < 10L) {
                result.append('0');
            }
            result.append(minuteDuration).append('m');
        } else if (minuteDuration > 0L) {
            result.append(minuteDuration).append('m');
        }
        if (result.length() > 0 && secondDuration < 10L) {
            result.append('0');
        }
        return result.append(secondDuration).append('s').toString();
    }

    private static FastDateFormat getOutputFormatter(String language) {
        FastDateFormat formatter = outputFormatters.get(language);
        if (formatter == null) {
            formatter = DateUtil.getDateOutputFormat(language);
            outputFormatters.put(language, formatter);
        }
        return formatter;
    }

    private static SimpleDateFormat getInputFormatter(String language) {
        SimpleDateFormat formatter = inputParsers.get(language);
        if (formatter == null) {
            formatter = DateUtil.getDateInputFormat(language);
            inputParsers.put(language, formatter);
        }
        return formatter;
    }

    public static String getFormattedTime(java.util.Date date) {
        return DateUtil.formatTime(date);
    }

    public static java.util.Date parseDate(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTime(DateUtil.parse(date));
        return DateUtil.resetHour(result).getTime();
    }

    public static Calendar resetHour(Calendar date) {
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        return date;
    }

    public static java.util.Date resetHour(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.Date parseDateTime(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = DATETIME_PARSER;
        synchronized (simpleDateFormat) {
            result.setTime(DATETIME_PARSER.parse(date));
        }
        return result.getTime();
    }

    public static java.util.Date parseTime(String time) throws ParseException {
        if (time == null) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTime(DateUtil.getDateUtil().parseWithTimeParser(time));
        return result.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.Date parseWithTimeParser(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.timeParser;
        synchronized (simpleDateFormat) {
            return this.timeParser.parse(date);
        }
    }

    public static String formatDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMATTER.format(date);
    }

    public static String formatDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return CUSTOM_FORMATTER.format(date);
    }

    public static String formatDate(Calendar calend) {
        if (calend == null) {
            return null;
        }
        return DATE_FORMATTER.format(calend.getTime());
    }

    public static String formatDate(java.util.Date date, String pattern) {
        SimpleDateFormat formater = new SimpleDateFormat(pattern);
        return formater.format(date);
    }

    public static void setTime(Calendar calend, String time) {
        calend.set(13, 0);
        calend.set(14, 0);
        if (time != null) {
            try {
                Calendar result = Calendar.getInstance();
                result.setTime(DateUtil.getDateUtil().parseWithTimeParser(time));
                calend.set(11, result.get(11));
                calend.set(12, result.get(12));
                return;
            }
            catch (ParseException pex) {
                SilverLogger.getLogger(DateUtil.class).warn((Throwable)pex);
            }
        }
        calend.set(11, 0);
        calend.set(12, 0);
    }

    public static String formatTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return TIME_FORMATTER.format(date);
    }

    public static String formatTime(Calendar calend) {
        if (calend == null) {
            return null;
        }
        return TIME_FORMATTER.format(calend.getTime());
    }

    public static String formatAsISO8601Date(java.util.Date date) {
        return ISO8601DATE_FORMATTER.format(date);
    }

    public static String formatAsISO8601Day(java.util.Date date) {
        return ISO8601DAY_FORMATTER.format(date);
    }

    public static String formatAsICalDate(java.util.Date date) {
        return ICALDATE_FORMATTER.format(date);
    }

    public static String formatAsICalUTCDate(java.util.Date date) {
        return ICALUTCDATE_FORMATTER.format(date);
    }

    public static String formatAsICalDay(java.util.Date date) {
        return ICALDAY_FORMATTER.format(date);
    }

    public static java.util.Date parseISO8601Date(String date) throws ParseException {
        return DateUtils.parseDate((String)date, (String[])new String[]{ISO8601DATE_FORMATTER.getPattern(), ISO8601DAY_FORMATTER.getPattern()});
    }

    public static java.util.Date getFirstDateOfYear(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getEndDateOfYear(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 11);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(calendar.get(1), calendar.get(2) + 1, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDateOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getEndDateOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(calendar.get(1), calendar.get(2) + 1, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDateOfWeek(java.util.Date date, String language) {
        Locale locale = DateUtil.getLocale(language);
        Calendar calendar = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, DateUtil.getFirstDayOfWeek(locale));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getEndDateOfWeek(java.util.Date date, String language) {
        Locale locale = DateUtil.getLocale(language);
        Calendar calendar = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, DateUtil.getFirstDayOfWeek(locale));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.add(5, 6);
        return calendar.getTime();
    }

    private static Locale getLocale(String locale) {
        if (StringUtil.isDefined((String)locale)) {
            Locale l;
            if (locale.contains("_")) {
                String[] i18n = locale.split("_");
                l = new Locale(i18n[0], i18n[1]);
            } else {
                switch (locale) {
                    case "fr": {
                        l = Locale.FRANCE;
                        break;
                    }
                    case "en": {
                        l = Locale.US;
                        break;
                    }
                    case "de": {
                        l = Locale.GERMANY;
                        break;
                    }
                    default: {
                        l = new Locale(locale);
                    }
                }
            }
            return l;
        }
        return null;
    }

    public static int getFirstDayOfWeek(String localeCode) {
        Locale locale = DateUtil.getLocale(localeCode);
        return DateUtil.getFirstDayOfWeek(locale);
    }

    public static int getFirstDayOfWeek(Locale locale) {
        Calendar calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        return calendar.getFirstDayOfWeek();
    }

    public static java.util.Date getEndOfDay(java.util.Date curDate) {
        if (curDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(curDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
        return null;
    }

    public static java.util.Date getBeginOfDay(java.util.Date curDate) {
        if (curDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(curDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static void setAtBeginOfDay(Calendar calendar) {
        if (calendar != null) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
    }

    public static void addDaysExceptWeekEnds(Calendar calendar, int nbDay) {
        int nb = 0;
        while (nb < nbDay) {
            calendar.add(5, 1);
            if (calendar.get(7) == 7 || calendar.get(7) == 1) continue;
            ++nb;
        }
    }

    public static int getDayNumberInWeek(java.util.Date curDate) {
        return DateUtil.convert(curDate).get(7);
    }

    public static int getDayNumberBetween(java.util.Date date1, java.util.Date date2) {
        return UnitUtil.getDuration(date2.getTime() - date1.getTime()).getTimeConverted(TimeUnit.DAY).intValue();
    }

    public static Calendar convert(java.util.Date curDate) {
        return DateUtil.convert(curDate, null);
    }

    public static Calendar convert(java.util.Date curDate, String language) {
        Locale locale = DateUtil.getLocale(language);
        Calendar cal = locale != null ? Calendar.getInstance(locale) : Calendar.getInstance();
        cal.setTime(curDate);
        return cal;
    }

    public static String formatAsLuceneDate(LocalDate date) {
        return LUCENE_FORMATTER.format(date);
    }

    public static LocalDate parseFromLucene(String date) {
        if (date == null) {
            return null;
        }
        return LocalDate.parse(date, LUCENE_FORMATTER);
    }

    public static LocalDate toLocalDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

