/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;

@Deprecated
public class SilverpeasBeanDAOImpl<T extends SilverpeasBean>
implements SilverpeasBeanDAO<T> {
    private final List<PropertyDescriptor> validProperties;
    private final Class<T> silverpeasBeanClass;
    private final String tableName;

    public SilverpeasBeanDAOImpl(Class<T> beanClassName) throws PersistenceException {
        try {
            this.silverpeasBeanClass = beanClassName;
            SilverpeasBean bean = (SilverpeasBean)this.silverpeasBeanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            BeanInfo infos = Introspector.getBeanInfo(this.silverpeasBeanClass);
            this.validProperties = Arrays.stream(infos.getPropertyDescriptors()).filter(p -> {
                String type = p.getPropertyType().getName();
                if (!this.isTypeValid(type)) {
                    SilverLogger.getLogger((Object)this).debug("as {0} is not a valid type, {1} is not taken into account for {2}", new Object[]{type, p.getName(), this.silverpeasBeanClass.getSimpleName()});
                    return false;
                }
                if (p.getWriteMethod() == null) {
                    SilverLogger.getLogger((Object)this).debug("as {0} is a property without dedicated setter, it isn't taken into account for {1}", new Object[]{p.getName(), this.silverpeasBeanClass.getSimpleName()});
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            this.tableName = bean.getTableName();
            Objects.requireNonNull(this.tableName);
        }
        catch (IntrospectionException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new PersistenceException("Cannot initialize bean " + beanClassName, ex);
        }
    }

    @Override
    public void remove(WAPrimaryKey pk) throws PersistenceException {
        this.remove(null, pk);
    }

    @Override
    public void remove(Connection connection, WAPrimaryKey pk) throws PersistenceException {
        String updateStatement = "delete from " + this.tableName + " where id = ?";
        this.perform(connection, con -> {
            try (PreparedStatement prepStmt = con.prepareStatement(updateStatement);){
                prepStmt.setInt(1, Integer.parseInt(pk.getId()));
                prepStmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new PersistenceException("Cannot remove bean with id (" + pk.getId() + ", " + pk.getInstanceId() + ")", e);
            }
        });
    }

    @Override
    public void removeBy(BeanCriteria criteria) throws PersistenceException {
        this.removeBy(null, criteria);
    }

    @Override
    public void removeBy(Connection connection, BeanCriteria criteria) throws PersistenceException {
        String query = "delete from " + this.tableName;
        this.perform(connection, con -> {
            try (PreparedStatement prepStmt = criteria.withConnection(con).applyTo(query);){
                prepStmt.executeUpdate();
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot remove bean by criteria", e);
            }
        });
    }

    @Override
    public void update(T bean) throws PersistenceException {
        this.update(null, bean);
    }

    @Override
    public void update(Connection connection, T bean) throws PersistenceException {
        StringBuilder statement = new StringBuilder();
        for (PropertyDescriptor property : this.validProperties) {
            if (statement.length() > 0) {
                statement.append(", ");
            }
            statement.append(property.getName()).append(" = ?");
        }
        String updateStatement = "UPDATE " + this.tableName + " SET " + statement + " WHERE id = ?";
        this.perform(connection, con -> {
            try (PreparedStatement prepStmt = con.prepareStatement(updateStatement);){
                int count = this.prepareStatementSetProperties(prepStmt, bean);
                prepStmt.setInt(count, Integer.parseInt(bean.getPK().getId()));
                prepStmt.executeUpdate();
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot update bean with id (" + bean.getPK().getId() + ", " + bean.getPK().getInstanceId() + ")", e);
            }
        });
    }

    @Override
    public WAPrimaryKey add(T bean) throws PersistenceException {
        return this.add(null, bean);
    }

    @Override
    public WAPrimaryKey add(Connection connection, T bean) throws PersistenceException {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (PropertyDescriptor property : this.validProperties) {
            if (columns.length() > 0) {
                columns.append(", ");
                values.append(", ");
            }
            columns.append(property.getName());
            values.append("?");
        }
        columns.append(", id");
        values.append(", ? ");
        String insertStatement = "INSERT INTO " + this.tableName + " (" + columns + ")  values (" + values + ")";
        Mutable pk = Mutable.empty();
        this.perform(connection, con -> {
            try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
                int count = this.prepareStatementSetProperties(prepStmt, bean);
                int id = DBUtil.getNextId(this.getTableName(bean.getPK()), "id");
                prepStmt.setInt(count, id);
                prepStmt.executeUpdate();
                bean.getPK().setId("" + id);
                pk.set((Object)bean.getPK());
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot save bean", e);
            }
        });
        return (WAPrimaryKey)pk.get();
    }

    @Override
    public T findByPrimaryKey(WAPrimaryKey pk) throws PersistenceException {
        return (T)this.findByPrimaryKey(null, pk);
    }

    @Override
    public T findByPrimaryKey(Connection connection, WAPrimaryKey pk) throws PersistenceException {
        String selectStatement = "SELECT  " + this.getColumnNames() + " FROM " + this.tableName + " WHERE id = ?";
        Mutable entity = Mutable.empty();
        this.perform(connection, con -> {
            try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
                prepStmt.setInt(1, Integer.parseInt(pk.getId()));
                try (ResultSet rs = prepStmt.executeQuery();){
                    if (rs.next()) {
                        T result = this.getSilverpeasBeanFromResultSet(rs);
                        entity.set(result);
                    }
                }
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot find bean with id (" + pk.getId() + ", " + pk.getInstanceId() + ")", e);
            }
        });
        return (T)((SilverpeasBean)entity.orElse(null));
    }

    @Override
    public Collection<T> findBy(BeanCriteria criteria) throws PersistenceException {
        return this.findBy(null, criteria);
    }

    @Override
    public Collection<T> findBy(Connection connection, BeanCriteria criteria) throws PersistenceException {
        Mutable entities = Mutable.of(new ArrayList());
        this.perform(connection, con -> {
            String selectStatement = "SELECT DISTINCT " + this.getColumnNames() + " FROM " + this.tableName;
            try (PreparedStatement prepStmt = criteria.withConnection(con).applyTo(selectStatement);
                 ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    T bean = this.getSilverpeasBeanFromResultSet(rs);
                    ((List)entities.get()).add(bean);
                }
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot find any beans satisfying the criteria " + criteria.toString(), e);
            }
        });
        return (Collection)entities.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(Connection connection, DataSourceTask task) throws PersistenceException {
        Connection con = this.getConnection(connection);
        try {
            task.execute(con);
        }
        finally {
            if (connection == null) {
                DBUtil.close(con);
            }
        }
    }

    private Connection getConnection(Connection connection) throws PersistenceException {
        if (connection != null) {
            return connection;
        }
        try {
            return DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException("Datasource connection opening failure!", e);
        }
    }

    private String getColumnNames() {
        StringBuilder statement = new StringBuilder();
        for (PropertyDescriptor property : this.validProperties) {
            if (statement.length() > 0) {
                statement.append(", ");
            }
            statement.append(property.getName());
        }
        statement.append(", id");
        return statement.toString();
    }

    private T getSilverpeasBeanFromResultSet(ResultSet rs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, SQLException, ParseException {
        Constructor<T> constructor = this.silverpeasBeanClass.getDeclaredConstructor(new Class[0]);
        SilverpeasBean bean = (SilverpeasBean)constructor.newInstance(new Object[0]);
        int count = 1;
        String instanceId = null;
        for (PropertyDescriptor property : this.validProperties) {
            Object[] parameters;
            String type = property.getPropertyType().getName();
            if (this.isInteger(type)) {
                parameters = this.getIntParams(rs, count);
                ++count;
            } else if (this.isLong(type)) {
                parameters = this.getLongParams(rs, count);
                ++count;
            } else if (this.isBoolean(type)) {
                parameters = this.getBooleanParams(rs, count);
                ++count;
            } else if (this.isString(type)) {
                parameters = this.getStringParams(rs, count);
                ++count;
            } else if (this.isDate(type)) {
                parameters = this.getDateParams(rs, count);
                ++count;
            } else if (this.isFloat(type)) {
                parameters = this.getFloatParams(rs, count);
                ++count;
            } else if (this.isDouble(type)) {
                parameters = this.getDoubleParams(rs, count);
                ++count;
            } else {
                parameters = null;
            }
            if (parameters != null) {
                property.getWriteMethod().invoke((Object)bean, parameters);
            }
            if (parameters == null || !property.getName().equals("instanceId")) continue;
            instanceId = (String)parameters[0];
        }
        this.setBeanPK(instanceId, rs, bean, count);
        return (T)bean;
    }

    private Object[] getDoubleParams(ResultSet rs, int idx) throws SQLException {
        Double[] parameters = null;
        double value = rs.getDouble(idx);
        if (!rs.wasNull()) {
            parameters = new Double[]{value};
        }
        return parameters;
    }

    private Object[] getFloatParams(ResultSet rs, int idx) throws SQLException {
        Float[] parameters = null;
        float value = rs.getFloat(idx);
        if (!rs.wasNull()) {
            parameters = new Float[]{Float.valueOf(value)};
        }
        return parameters;
    }

    private Object[] getDateParams(ResultSet rs, int idx) throws SQLException, ParseException {
        Date[] parameters = null;
        String value = rs.getString(idx);
        if (value != null) {
            parameters = new Date[]{DateUtil.parse(value)};
        }
        return parameters;
    }

    private Object[] getStringParams(ResultSet rs, int idx) throws SQLException {
        String[] parameters = null;
        String value = rs.getString(idx);
        if (value != null) {
            parameters = new String[]{value};
        }
        return parameters;
    }

    private Object[] getBooleanParams(ResultSet rs, int idx) throws SQLException {
        Boolean[] parameters = null;
        boolean value = rs.getBoolean(idx);
        if (!rs.wasNull()) {
            parameters = new Boolean[]{value};
        }
        return parameters;
    }

    private Object[] getLongParams(ResultSet rs, int idx) throws SQLException {
        Long[] parameters = null;
        long value = rs.getLong(idx);
        if (!rs.wasNull()) {
            parameters = new Long[]{value};
        }
        return parameters;
    }

    private Object[] getIntParams(ResultSet rs, int idx) throws SQLException {
        Integer[] parameters = null;
        int value = rs.getInt(idx);
        if (!rs.wasNull()) {
            parameters = new Integer[]{value};
        }
        return parameters;
    }

    private void setBeanPK(String instanceId, ResultSet rs, T bean, int count) throws SQLException {
        String id = "" + rs.getInt(count);
        IdPK pk = new IdPK(id);
        pk.setComponentName(instanceId);
        ((SilverpeasBean)bean).setPK(pk);
    }

    private boolean isInteger(String type) {
        return "int".equals(type) || "java.lang.Integer".equals(type);
    }

    private boolean isLong(String type) {
        return "long".equals(type) || "java.lang.Long".equals(type);
    }

    private boolean isBoolean(String type) {
        return "boolean".equals(type) || "java.lang.Boolean".equals(type);
    }

    private boolean isString(String type) {
        return "java.lang.String".equals(type);
    }

    private boolean isDate(String type) {
        return "java.util.Date".equals(type);
    }

    private boolean isDouble(String type) {
        return "double".equals(type) || "java.lang.Double".equals(type);
    }

    private boolean isFloat(String type) {
        return "float".equals(type) || "java.lang.Float".equals(type);
    }

    private String getTableName(WAPrimaryKey pk) {
        String result = this.tableName != null ? this.tableName : pk.getTableName();
        return result;
    }

    private boolean isTypeValid(String javaTypeName) {
        return this.isInteger(javaTypeName) || this.isLong(javaTypeName) || this.isString(javaTypeName) || this.isDate(javaTypeName) || this.isFloat(javaTypeName) || this.isDouble(javaTypeName) || this.isBoolean(javaTypeName);
    }

    private int prepareStatementSetProperties(PreparedStatement prepStmt, T bean) throws IllegalAccessException, SQLException, InvocationTargetException {
        int count = 1;
        for (PropertyDescriptor property : this.validProperties) {
            Constable l;
            String type = property.getPropertyType().getName();
            if (this.isInteger(type)) {
                this.setInt(prepStmt, bean, count, property);
                ++count;
                continue;
            }
            if (this.isLong(type)) {
                l = (Long)property.getReadMethod().invoke(bean, new Object[0]);
                this.setLong(prepStmt, count, (Long)l);
                ++count;
                continue;
            }
            if (this.isBoolean(type)) {
                l = (Boolean)property.getReadMethod().invoke(bean, new Object[0]);
                this.setBoolean(prepStmt, count, (Boolean)l);
                ++count;
                continue;
            }
            if (this.isString(type)) {
                this.setString(prepStmt, bean, count, property);
                ++count;
                continue;
            }
            if (this.isDate(type)) {
                this.setDate(prepStmt, bean, count, property);
                ++count;
                continue;
            }
            if (this.isFloat(type)) {
                this.setFloat(prepStmt, bean, count, property);
                ++count;
                continue;
            }
            if (!this.isDouble(type)) continue;
            this.setDouble(prepStmt, bean, count, property);
            ++count;
        }
        return count;
    }

    private void setDouble(PreparedStatement prepStmt, T bean, int count, PropertyDescriptor property) throws IllegalAccessException, InvocationTargetException, SQLException {
        Double d = (Double)property.getReadMethod().invoke(bean, new Object[0]);
        prepStmt.setDouble(count, Objects.requireNonNullElse(d, 0.0));
    }

    private void setFloat(PreparedStatement prepStmt, T bean, int count, PropertyDescriptor property) throws IllegalAccessException, InvocationTargetException, SQLException {
        Float f = (Float)property.getReadMethod().invoke(bean, new Object[0]);
        prepStmt.setFloat(count, Objects.requireNonNullElse(f, Float.valueOf(0.0f)).floatValue());
    }

    private void setDate(PreparedStatement prepStmt, T bean, int count, PropertyDescriptor property) throws IllegalAccessException, InvocationTargetException, SQLException {
        Date date = (Date)property.getReadMethod().invoke(bean, new Object[0]);
        if (date == null) {
            prepStmt.setNull(count, 12);
        } else {
            prepStmt.setString(count, DateUtil.date2SQLDate(date));
        }
    }

    private void setString(PreparedStatement prepStmt, T bean, int count, PropertyDescriptor property) throws IllegalAccessException, InvocationTargetException, SQLException {
        String string = (String)property.getReadMethod().invoke(bean, new Object[0]);
        if (string == null) {
            prepStmt.setNull(count, 12);
        } else {
            prepStmt.setString(count, string);
        }
    }

    private void setBoolean(PreparedStatement prepStmt, int count, Boolean l) throws SQLException {
        prepStmt.setBoolean(count, Objects.requireNonNullElse(l, false));
    }

    private void setLong(PreparedStatement prepStmt, int count, Long l) throws SQLException {
        prepStmt.setLong(count, Objects.requireNonNullElse(l, 0L));
    }

    private void setInt(PreparedStatement prepStmt, T bean, int count, PropertyDescriptor property) throws IllegalAccessException, InvocationTargetException, SQLException {
        Integer integer = (Integer)property.getReadMethod().invoke(bean, new Object[0]);
        prepStmt.setInt(count, Objects.requireNonNullElse(integer, -1));
    }

    @FunctionalInterface
    private static interface DataSourceTask {
        public void execute(Connection var1) throws PersistenceException;
    }
}

