/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.ImageUtil;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.kernel.logging.SilverLogger;

public class FileFolderManager {
    private static final String NOT_A_DIRECTORY_MSG = " isn't a directory";

    public static Collection<File> getAllSubFolder(String path) {
        List<File> result;
        block9: {
            Path directory = Paths.get(path, new String[0]);
            if (directory.toFile().isDirectory()) {
                try (Stream<Path> folders = Files.list(directory);){
                    result = folders.map(Path::toFile).filter(File::isDirectory).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException e) {
                    throw new UtilException((Throwable)e);
                }
            }
            throw new UtilException(path + NOT_A_DIRECTORY_MSG);
        }
        return result;
    }

    public static Collection<File> getAllFile(String path) {
        List<File> result;
        block9: {
            Path directory = Paths.get(path, new String[0]);
            if (directory.toFile().isDirectory()) {
                try (Stream<Path> folders = Files.list(directory);){
                    result = folders.map(Path::toFile).filter(File::isFile).sorted((Comparator<File>)new NameFileComparator(IOCase.INSENSITIVE)).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException e) {
                    throw new UtilException((Throwable)e);
                }
            }
            throw new UtilException(path + NOT_A_DIRECTORY_MSG);
        }
        return result;
    }

    public static Collection<File> getAllImages(String path) {
        List<File> result;
        block9: {
            Path directory = Paths.get(path, new String[0]);
            if (directory.toFile().isDirectory()) {
                try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
                    result = files.map(Path::toFile).filter(file -> Stream.of(ImageUtil.IMAGE_EXTENTIONS).anyMatch(e -> file.getName().toLowerCase().endsWith(e.toLowerCase()))).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException e) {
                    throw new UtilException((Throwable)e);
                }
            }
            throw new UtilException(path + NOT_A_DIRECTORY_MSG);
        }
        return result;
    }

    public static Collection<File> getAllWebPages(String path) {
        List<File> result;
        block9: {
            Path directory = Paths.get(path, new String[0]);
            if (directory.toFile().isDirectory()) {
                try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
                    result = files.map(Path::toFile).filter(File::isFile).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException e) {
                    throw new UtilException((Throwable)e);
                }
            }
            throw new UtilException(path + NOT_A_DIRECTORY_MSG);
        }
        return result;
    }

    public static Collection<File> getAllHTMLWebPages(String path) {
        List<File> result;
        block9: {
            Path directory = Paths.get(path, new String[0]);
            if (directory.toFile().isDirectory()) {
                try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
                    result = files.map(Path::toFile).filter(File::isFile).filter(f -> f.getName().toLowerCase().endsWith(".html") || f.getName().toLowerCase().endsWith(".htm")).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException e) {
                    throw new UtilException((Throwable)e);
                }
            }
            throw new UtilException(path + NOT_A_DIRECTORY_MSG);
        }
        return result;
    }

    public static void createFolder(String path) {
        File directory = new File(path);
        if (!directory.exists() || directory.isDirectory()) {
            FileFolderManager.createFolder(directory);
        }
    }

    public static void createFolder(File directory) {
        try {
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
    }

    public static void moveFolder(String path, String newPath) {
        Path source = Paths.get(path, new String[0]);
        if (source.toFile().isDirectory()) {
            try {
                Files.move(source, Paths.get(newPath, new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UtilException((Throwable)e);
            }
        } else {
            throw new UtilException(path + NOT_A_DIRECTORY_MSG);
        }
    }

    public static void deleteFolder(String path) {
        try (Stream<Path> paths = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            SilverLogger.getLogger(FileFolderManager.class).warn((Throwable)e);
        }
    }

    public static void createFile(String directoryPath, String fileName, String fileContent) {
        Path folder = Paths.get(directoryPath, new String[0]);
        if (folder.toFile().isDirectory()) {
            try {
                Files.write(folder.resolve(fileName), fileContent.getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UtilException((Throwable)e);
            }
        } else {
            throw new UtilException(directoryPath + NOT_A_DIRECTORY_MSG);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void renameFile(String directoryPath, String name, String newName) {
        Path directory = Paths.get(directoryPath, new String[0]);
        if (!directory.toFile().isDirectory()) throw new UtilException(directoryPath + NOT_A_DIRECTORY_MSG);
        Path fileToRename = directory.resolve(name);
        if (!fileToRename.toFile().isFile()) throw new UtilException(fileToRename + " isn't a file");
        try {
            Files.move(fileToRename, directory.resolve(newName), new CopyOption[0]);
            return;
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
    }

    public static void deleteFile(String path) {
        try {
            Files.delete(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            throw new UtilException((Throwable)e);
        }
    }

    public static Optional<String> getFileContent(String directoryPath, String fileName) {
        Path directory = Paths.get(directoryPath, new String[0]);
        if (directory.toFile().isDirectory()) {
            String content = null;
            try {
                content = Files.readString(directory.resolve(fileName), Charsets.UTF_8);
            }
            catch (IOException e) {
                SilverLogger.getLogger(FileFolderManager.class).debug(directory.resolve(fileName) + "does not exist", new Object[0]);
            }
            return Optional.ofNullable(content);
        }
        throw new UtilException(directoryPath + NOT_A_DIRECTORY_MSG);
    }

    private FileFolderManager() {
    }
}

