/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.apache.commons.lang3.NotImplementedException;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.PasteDetailFromToPK;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.core.util.annotation.Language;
import org.silverpeas.core.util.annotation.SourcePK;
import org.silverpeas.core.util.annotation.TargetPK;

public class AnnotationUtil {
    private AnnotationUtil() {
    }

    private static Map<Class<? extends Annotation>, Annotation> extractMethodAnnotations(Method method) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> results = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : method.getAnnotations()) {
            results.put(annotation.annotationType(), annotation);
        }
        return results;
    }

    private static Map<Class<? extends Annotation>, List<Object>> extractMethodAnnotatedParameterValues(Method method, Object[] parameterValues) {
        LinkedHashMap<Class<? extends Annotation>, List<Object>> results = new LinkedHashMap<Class<? extends Annotation>, List<Object>>();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = annotations[i]) {
                Object parameterValue = parameterValues[i];
                if (parameterValue == null) continue;
                AnnotationUtil.processAnnotations(results, parameterAnnotation, parameterValue);
            }
        }
        return results;
    }

    private static void processAnnotations(Map<Class<? extends Annotation>, List<Object>> results, Annotation parameterAnnotation, Object parameterValue) {
        if (parameterAnnotation.annotationType().isAssignableFrom(SourcePK.class) || parameterAnnotation.annotationType().isAssignableFrom(TargetPK.class)) {
            if (parameterValue instanceof Collection) {
                for (Object value : (Collection)parameterValue) {
                    AnnotationUtil.addPKParameterValue(results, parameterAnnotation.annotationType(), value);
                }
            } else {
                AnnotationUtil.addPKParameterValue(results, parameterAnnotation.annotationType(), parameterValue);
            }
        } else if (parameterAnnotation.annotationType().isAssignableFrom(Language.class)) {
            String language = null;
            if (parameterValue instanceof String) {
                language = (String)parameterValue;
            } else if (parameterValue instanceof Locale) {
                language = ((Locale)parameterValue).getLanguage();
            }
            MapUtil.putAddList(results, parameterAnnotation.annotationType(), language);
        } else {
            MapUtil.putAddList(results, parameterAnnotation.annotationType(), parameterValue);
        }
    }

    private static void addPKParameterValue(Map<Class<? extends Annotation>, List<Object>> parameterValues, Class<? extends Annotation> annotationClass, Object object) {
        Object resourceRef;
        if (object instanceof Contribution) {
            resourceRef = ((Contribution)object).getIdentifier().toReference();
        } else if (object instanceof PasteDetailFromToPK) {
            PasteDetailFromToPK pasteDetail = (PasteDetailFromToPK)object;
            resourceRef = SourcePK.class.equals(annotationClass) ? pasteDetail.getFromPK() : pasteDetail.getToPK();
        } else if (object instanceof ResourceReference) {
            resourceRef = (ResourceReference)object;
        } else {
            resourceRef = null;
            if (object != null) {
                throw new NotImplementedException("No implementation to address type " + object.getClass().getName() + " in simulation processing of actions");
            }
        }
        if (resourceRef != null) {
            MapUtil.putAddList(parameterValues, annotationClass, resourceRef);
        }
    }

    public static Map<Class<? extends Annotation>, Annotation> extractMethodAnnotations(InvocationContext invocationContext) {
        return AnnotationUtil.extractMethodAnnotations(AnnotationUtil.getInterceptedMethodFromContext(invocationContext));
    }

    public static Map<Class<? extends Annotation>, List<Object>> extractMethodAnnotatedParameterValues(InvocationContext invocationContext) {
        return AnnotationUtil.extractMethodAnnotatedParameterValues(AnnotationUtil.getInterceptedMethodFromContext(invocationContext), invocationContext.getParameters());
    }

    public static <T> List<T> getAnnotatedValues(Map<Class<? extends Annotation>, List<Object>> annotatedValues, Class<? extends Annotation> annotationClass) {
        List<Object> result = null;
        if (annotatedValues != null) {
            result = annotatedValues.get(annotationClass);
        }
        if (result == null) {
            result = new ArrayList<Object>(0);
        }
        return result;
    }

    private static Method getInterceptedMethodFromContext(InvocationContext invocationContext) {
        return invocationContext.getMethod();
    }
}

