/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.process.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.silverpeas.core.process.annotation.InterceptorBindingOfSimulationActionProcess;
import org.silverpeas.core.process.annotation.SimulationActionProcess;
import org.silverpeas.core.process.annotation.SimulationActionProcessProcessor;
import org.silverpeas.core.process.annotation.SimulationElementLister;
import org.silverpeas.core.util.annotation.Action;
import org.silverpeas.core.util.annotation.AnnotationUtil;
import org.silverpeas.core.util.annotation.Language;
import org.silverpeas.core.util.annotation.SourceObject;
import org.silverpeas.core.util.annotation.SourcePK;
import org.silverpeas.core.util.annotation.TargetPK;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@InterceptorBindingOfSimulationActionProcess
@Interceptor
@Priority(value=2000)
public class SimulationActionProcessAnnotationInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) {
        Map<Class<? extends Annotation>, Annotation> methodAnnotations = AnnotationUtil.extractMethodAnnotations(invocationContext);
        Map<Class<? extends Annotation>, List<Object>> annotatedParametersValues = AnnotationUtil.extractMethodAnnotatedParameterValues(invocationContext);
        return this.perform(invocationContext, methodAnnotations, annotatedParametersValues);
    }

    protected Object perform(InvocationContext context, Map<Class<? extends Annotation>, Annotation> methodAnnotations, Map<Class<? extends Annotation>, List<Object>> annotatedParametersValues) {
        return SimulationActionProcessProcessor.get().withContext(s -> {
            List sourcePKs = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, SourcePK.class);
            s.getSourcePKs().addAll(sourcePKs);
            List sourceObjects = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, SourceObject.class);
            s.getSourceObjects().addAll(sourceObjects);
        }).listElementsWith(() -> {
            SimulationActionProcess simulationActionProcess = this.getSimulationActionProcess(methodAnnotations);
            try {
                Constructor<? extends SimulationElementLister> constructor = simulationActionProcess.elementLister().getDeclaredConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }).byAction(() -> {
            Action actionType = this.getAction(methodAnnotations);
            return actionType.value();
        }).toTargets(t -> {
            List targetPKs = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, TargetPK.class);
            t.getTargetPKs().addAll(targetPKs);
        }).setLanguage(() -> {
            List languages = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, Language.class);
            return languages.isEmpty() ? null : (String)languages.get(0);
        }).fromMethod(context.getMethod()).execute(() -> this.proceed(context));
    }

    @Nonnull
    private Action getAction(Map<Class<? extends Annotation>, Annotation> methodAnnotations) {
        Action actionType = (Action)methodAnnotations.get(Action.class);
        if (actionType == null) {
            throw new AssertionError((Object)"actionType is null (Action annotation must be specified on the method)");
        }
        return actionType;
    }

    @Nonnull
    private SimulationActionProcess getSimulationActionProcess(Map<Class<? extends Annotation>, Annotation> methodAnnotations) {
        SimulationActionProcess simulationActionProcess = (SimulationActionProcess)methodAnnotations.get(SimulationActionProcess.class);
        if (simulationActionProcess == null) {
            throw new AssertionError((Object)"simulationActionProcess is null (SimulationActionProcess annotation must be specified on the method)");
        }
        return simulationActionProcess;
    }

    protected Object proceed(InvocationContext context) throws Exception {
        return context.proceed();
    }
}

