/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.user.NullUserNotification;
import org.silverpeas.core.notification.user.RemoveSenderRecipientBehavior;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationSendingHandler;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.client.ExternalRecipient;
import org.silverpeas.core.notification.user.client.GroupRecipient;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.client.constant.NotifMessageType;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractUserNotificationBuilder
implements UserNotificationBuilder {
    private String title = null;
    private String content = null;
    private UserNotification userNotification = null;

    protected AbstractUserNotificationBuilder() {
    }

    protected AbstractUserNotificationBuilder(String title, String content) {
        this();
        this.title = title;
        this.content = content;
    }

    protected void initialize() {
        this.userNotification = this.createNotification();
        this.getNotificationMetaData().setMessageType(this.getMessageType().getId());
        this.getNotificationMetaData().setAction(this.getAction());
        this.getNotificationMetaData().setComponentId(this.getComponentInstanceId());
        this.getNotificationMetaData().setSender(this.getSender());
        this.getNotificationMetaData().setSendImmediately(this.isSendImmediately());
    }

    protected abstract UserNotification createNotification();

    protected abstract NotifAction getAction();

    protected abstract String getComponentInstanceId();

    protected abstract String getSender();

    protected abstract boolean isUserCanBeNotified(String var1);

    protected abstract boolean isGroupCanBeNotified(String var1);

    protected final NotificationMetaData getNotificationMetaData() {
        return this.userNotification.getNotificationMetaData();
    }

    protected NotifMessageType getMessageType() {
        return NotifMessageType.NORMAL;
    }

    protected boolean isSendImmediately() {
        return false;
    }

    public final UserNotification build() {
        Mutable userNote = Mutable.empty();
        try {
            if (this.isUserSubscriptionNotification() && (NotifAction.UPDATE == this.getAction() || NotifAction.CLASSIFIED == this.getAction())) {
                UserSubscriptionNotificationSendingHandler handler = UserSubscriptionNotificationSendingHandler.get();
                if (!handler.isSubscriptionNotificationEnabledForCurrentRequest()) {
                    this.stop();
                } else {
                    userNote.set((Object)handler.getSubscriptionNotificationUserNoteFromCurrentRequest());
                }
            }
            this.initialize();
            this.performUsersToBeNotified();
            this.performBuild();
        }
        catch (Stop e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
            this.userNotification = new NullUserNotification();
        }
        if (StringUtil.isDefined((String)((String)userNote.orElse(null)))) {
            DisplayI18NHelper.getLanguages().forEach(l -> this.userNotification.getNotificationMetaData().addExtraMessage((String)userNote.get(), l));
        }
        return this.userNotification;
    }

    protected abstract Collection<String> getUserIdsToNotify();

    protected Collection<String> getUserIdsToExcludeFromNotifying() {
        return Collections.emptyList();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return Collections.emptyList();
    }

    protected Collection<String> getExternalAddressesToNotify() {
        return Collections.emptyList();
    }

    private void performUsersToBeNotified() {
        Collection userIdsToNotify = this.getSafeCollection(this.getUserIdsToNotify()).stream().filter(this::isUserCanBeNotified).collect(Collectors.toSet());
        Collection<String> userIdsToExcludeFromNotifying = this.getUserIdsToExcludeFromNotifying();
        Collection groupIdsToNotify = this.getSafeCollection(this.getGroupIdsToNotify()).stream().filter(this::isGroupCanBeNotified).collect(Collectors.toSet());
        Collection<String> emailsToNotify = this.getExternalAddressesToNotify();
        if (this.stopWhenNoUserToNotify() && CollectionUtil.isEmpty((Collection)userIdsToNotify) && CollectionUtil.isEmpty((Collection)groupIdsToNotify) && CollectionUtil.isEmpty(emailsToNotify)) {
            SilverLogger.getLogger((Object)this).info("No user or groups to notify!", new Object[0]);
            this.stop();
        }
        this.addUserRecipients(userIdsToNotify, userIdsToExcludeFromNotifying);
        this.addGroupRecipients(groupIdsToNotify);
        this.addExternalRecipients(emailsToNotify);
    }

    private Collection<String> getSafeCollection(Collection<String> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    private void addExternalRecipients(Collection<String> emailsToNotify) {
        if (CollectionUtil.isNotEmpty(emailsToNotify)) {
            for (String address : emailsToNotify) {
                this.getNotificationMetaData().addExternalRecipient(new ExternalRecipient(address));
            }
        }
    }

    private void addGroupRecipients(Collection<String> groupIdsToNotify) {
        if (CollectionUtil.isNotEmpty(groupIdsToNotify)) {
            for (String groupId : groupIdsToNotify) {
                this.getNotificationMetaData().addGroupRecipient(new GroupRecipient(groupId));
            }
        }
    }

    private void addUserRecipients(Collection<String> userIdsToNotify, Collection<String> userIdsToExcludeFromNotifying) {
        if (CollectionUtil.isNotEmpty(userIdsToNotify)) {
            for (String userId : userIdsToNotify) {
                this.getNotificationMetaData().addUserRecipient(new UserRecipient(userId));
            }
        }
        if (CollectionUtil.isNotEmpty(userIdsToExcludeFromNotifying)) {
            for (String userId : userIdsToExcludeFromNotifying) {
                this.getNotificationMetaData().addUserRecipientToExclude(new UserRecipient(userId));
            }
        }
        if (this instanceof RemoveSenderRecipientBehavior && StringUtil.isInteger((String)this.getSender())) {
            boolean excludeSender;
            boolean bl = excludeSender = !(this instanceof UserSubscriptionNotificationBehavior) || NotificationManagerSettings.isRemoveSenderFromSubscriptionNotificationReceiversEnabled();
            if (excludeSender) {
                this.getNotificationMetaData().addUserRecipientToExclude(new UserRecipient(this.getSender()));
            }
        }
    }

    protected boolean stopWhenNoUserToNotify() {
        return true;
    }

    protected abstract void performBuild();

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.multilang.generalMultilang";
    }

    protected final LocalizationBundle getBundle() {
        return this.getBundle(I18NHelper.DEFAULT_LANGUAGE);
    }

    protected final LocalizationBundle getBundle(String language) {
        LocalizationBundle bundle = null;
        if (StringUtils.isNotBlank((CharSequence)this.getLocalizationBundlePath())) {
            bundle = ResourceLocator.getLocalizationBundle((String)this.getLocalizationBundlePath(), (String)language);
        }
        return bundle;
    }

    protected String getTitle() {
        return this.title;
    }

    protected String getContent() {
        return this.content;
    }

    protected void stop() {
        throw new Stop();
    }

    private boolean isUserSubscriptionNotification() {
        return this instanceof UserSubscriptionNotificationBehavior;
    }

    private static class Stop
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private Stop() {
        }
    }
}

