/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.io.file.ImageResizingProcessor;
import org.silverpeas.kernel.logging.SilverLogger;

class ImageCache {
    private static final String IMAGE_CACHE_TABLE = ImageResizingProcessor.IMAGE_CACHE_PATH + File.separatorChar + ".data";

    private ImageCache() {
    }

    protected static void putImage(String originalImagePath, String resizedImagePath) {
        String entryName = ImageCache.hash(originalImagePath);
        File entry = new File(IMAGE_CACHE_TABLE, entryName);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            if (!entry.exists()) {
                lines.add(originalImagePath);
            }
            lines.add(resizedImagePath);
            FileUtils.writeLines((File)entry, lines, (boolean)true);
        }
        catch (IOException ex) {
            SilverLogger.getLogger(ImageCache.class).error("Cannot write the cache entry {0} with value {1}. Cause: {2}", new Object[]{entry.getAbsolutePath(), resizedImagePath, ex.getMessage()});
        }
    }

    protected static void removeImages(String ... originalImagePaths) {
        for (String anOriginalImage : originalImagePaths) {
            String entryName = ImageCache.hash(anOriginalImage);
            File entry = new File(IMAGE_CACHE_TABLE, entryName);
            if (!entry.exists()) continue;
            ImageCache.removeEachImageIn(entry);
        }
    }

    private static void removeEachImageIn(File entry) {
        try {
            List lines = FileUtils.readLines((File)entry, (Charset)Charset.defaultCharset());
            for (String resizedImagePath : lines.subList(1, lines.size())) {
                File resizedImage = new File(resizedImagePath);
                if (!resizedImage.exists() || Files.deleteIfExists(resizedImage.toPath())) continue;
                SilverLogger.getLogger(ImageCache.class).warn("Cannot remove {0} from the cache entry {1}", new Object[]{resizedImage.getAbsolutePath(), entry.getAbsolutePath()});
            }
            if (!Files.deleteIfExists(entry.toPath())) {
                SilverLogger.getLogger(ImageCache.class).warn("Cannot delete the cache entry {0}", new Object[]{entry.getAbsolutePath()});
            }
        }
        catch (IOException ex) {
            SilverLogger.getLogger(ImageCache.class).error(ex.getMessage(), new Object[]{ex.getMessage()});
        }
    }

    protected static List<String> getImages(String originalImagePath) {
        String entryName = ImageCache.hash(originalImagePath);
        File entry = new File(IMAGE_CACHE_TABLE, entryName);
        if (entry.exists()) {
            try {
                List lines = FileUtils.readLines((File)entry, (Charset)Charset.defaultCharset());
                if (!lines.isEmpty()) {
                    return lines.subList(1, lines.size());
                }
            }
            catch (IOException ex) {
                SilverLogger.getLogger(ImageCache.class).error(ex.getMessage(), new Object[0]);
            }
        }
        return Collections.emptyList();
    }

    protected static List<String> getAllImageEntries() {
        ArrayList<String> originalImagePaths = new ArrayList<String>();
        File entries = new File(IMAGE_CACHE_TABLE);
        File[] files = entries.listFiles();
        if (files != null) {
            for (File anEntry : files) {
                try {
                    List resizedImagePaths = FileUtils.readLines((File)anEntry, (Charset)Charset.defaultCharset());
                    originalImagePaths.add((String)resizedImagePaths.get(0));
                }
                catch (IOException ex) {
                    SilverLogger.getLogger(ImageCache.class).error(ex.getMessage(), new Object[0]);
                }
            }
        }
        return originalImagePaths;
    }

    private static String hash(String name) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(name.getBytes(), 0, name.length());
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            SilverLogger.getLogger(ImageCache.class).warn(e.getMessage(), new Object[0]);
            return String.valueOf(name.hashCode());
        }
    }
}

