/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import javax.inject.Inject;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.index.indexing.model.IndexManager;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.thread.task.RequestTaskManager;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class IndexerTask
extends AbstractRequestTask<IndexerProcessContext> {
    private static final int QUEUE_LIMIT = 200;
    @Inject
    private IndexManager indexManager;

    public static void addIndexEntry(FullIndexEntry indexEntry) {
        RequestTaskManager.get().push(IndexerTask.class, (AbstractRequestTask.Request)new AddIndexEntryRequest(indexEntry));
    }

    public static void removeIndexEntry(IndexEntryKey indexEntry) {
        RequestTaskManager.get().push(IndexerTask.class, (AbstractRequestTask.Request)new RemoveIndexEntryRequest(indexEntry));
    }

    public static void removeIndexEntriesByScope(String scope) {
        RequestTaskManager.get().push(IndexerTask.class, (AbstractRequestTask.Request)new RemoveScopedIndexEntriesRequest(scope));
    }

    public static void removeAllIndexEntries() {
        RequestTaskManager.get().push(IndexerTask.class, (AbstractRequestTask.Request)new RemoveAllIndexEntriesRequest());
    }

    protected int getRequestQueueLimit() {
        return 200;
    }

    protected void afterNoMoreRequest() {
        super.afterNoMoreRequest();
        this.indexManager.flush();
    }

    protected IndexerProcessContext getProcessContext() {
        return new IndexerProcessContext(this.indexManager);
    }

    static class RemoveAllIndexEntriesRequest
    implements AbstractRequestTask.Request<IndexerProcessContext> {
        RemoveAllIndexEntriesRequest() {
        }

        public void process(IndexerProcessContext context) {
            context.getIndexManager().removeAllIndexEntries();
        }
    }

    static class RemoveScopedIndexEntriesRequest
    implements AbstractRequestTask.Request<IndexerProcessContext> {
        private final String scope;

        RemoveScopedIndexEntriesRequest(String scope) {
            this.scope = scope;
        }

        public void process(IndexerProcessContext context) {
            context.getIndexManager().removeIndexEntries(this.scope);
        }
    }

    static class RemoveIndexEntryRequest
    implements AbstractRequestTask.Request<IndexerProcessContext> {
        private final IndexEntryKey indexEntry;

        RemoveIndexEntryRequest(IndexEntryKey indexEntry) {
            this.indexEntry = indexEntry;
        }

        public void process(IndexerProcessContext context) {
            context.getIndexManager().removeIndexEntry(this.indexEntry);
        }
    }

    static class AddIndexEntryRequest
    implements AbstractRequestTask.Request<IndexerProcessContext> {
        private final FullIndexEntry indexEntry;

        AddIndexEntryRequest(FullIndexEntry indexEntry) {
            this.indexEntry = indexEntry;
        }

        public void process(IndexerProcessContext context) {
            context.getIndexManager().addIndexEntry(this.indexEntry);
        }
    }

    protected static class IndexerProcessContext
    implements AbstractRequestTask.ProcessContext {
        private final IndexManager indexManager;

        IndexerProcessContext(IndexManager indexManager) {
            this.indexManager = indexManager;
        }

        IndexManager getIndexManager() {
            return this.indexManager;
        }
    }
}

