/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class IndexReadersCache {
    private static final Object READER_MUTEX = new Object();
    private static final Map<String, IndexReader> INDEX_READERS = new HashMap<String, IndexReader>();
    private static final BiConsumer<String, IndexReader> CLOSE_INDEX_CONSUMER = (s, r) -> {
        SilverLogger logger = IndexingLogger.indexingLogger();
        try {
            logger.debug("closing reader of path {0}", new Object[]{s});
            r.close();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
    };

    private IndexReadersCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexReader getIndexReader(String path) {
        Object object = READER_MUTEX;
        synchronized (object) {
            File rootPath = new File(path);
            boolean validRootPath = ArrayUtil.isNotEmpty(rootPath.list());
            IndexReader indexReader = INDEX_READERS.get(path);
            if (indexReader == null && validRootPath) {
                try {
                    indexReader = DirectoryReader.open((Directory)FSDirectory.open((Path)rootPath.toPath()));
                    INDEX_READERS.put(path, indexReader);
                }
                catch (Exception e) {
                    IndexingLogger.indexingLogger().warn((Throwable)e);
                }
            } else if (indexReader != null && !validRootPath) {
                IndexingLogger.indexingLogger().warn("index reader exists in cache but no index path is existing! ({0})", new Object[]{path});
                IndexReadersCache.closeIndexReader(path);
                indexReader = null;
            } else if (!validRootPath) {
                IndexingLogger.indexingLogger().debug("index reader for path {0} can not be open as there is no index data", new Object[]{path});
            }
            return indexReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeIndexReader(String path) {
        Object object = READER_MUTEX;
        synchronized (object) {
            IndexReader indexReader = INDEX_READERS.remove(path);
            if (indexReader != null) {
                CLOSE_INDEX_CONSUMER.accept(path, indexReader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeAllIndexReaders() {
        Object object = READER_MUTEX;
        synchronized (object) {
            INDEX_READERS.forEach(CLOSE_INDEX_CONSUMER);
            INDEX_READERS.clear();
        }
    }
}

